/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractListModel;

public class ListModelAdapter<E>
extends AbstractListModel
implements List<E> {
    private static final long serialVersionUID = -8453375309510933002L;
    protected final List<E> _internalList;

    public ListModelAdapter(List<E> oInternalList) {
        this._internalList = oInternalList;
    }

    public ListModelAdapter() {
        this(new ArrayList());
    }

    @Override
    public Object getElementAt(int iIndex) {
        return this._internalList.get(iIndex);
    }

    @Override
    public int getSize() {
        return this._internalList.size();
    }

    @Override
    public boolean add(E oElement) {
        this.add(this.size(), oElement);
        return true;
    }

    @Override
    public void add(int iIndex, E oElement) {
        this._internalList.add(iIndex, oElement);
        this.fireIntervalAdded(this, iIndex, iIndex);
    }

    @Override
    public boolean addAll(Collection<? extends E> oCollection) {
        this.addAll(this.size(), oCollection);
        return true;
    }

    @Override
    public boolean addAll(int iIndex, Collection<? extends E> oCollection) {
        boolean bResult = this._internalList.addAll(iIndex, oCollection);
        this.fireIntervalAdded(this, iIndex, iIndex + oCollection.size() - 1);
        return bResult;
    }

    @Override
    public void clear() {
        int iSizeBefore = this.size();
        this._internalList.clear();
        this.fireIntervalRemoved(this, 0, iSizeBefore - 1);
    }

    @Override
    public E remove(int iIndex) {
        E oResult = this._internalList.remove(iIndex);
        this.fireIntervalRemoved(this, iIndex, iIndex);
        return oResult;
    }

    @Override
    public boolean remove(Object o) {
        int iIndex = this.indexOf(o);
        if (iIndex < 0) {
            return false;
        }
        this.remove(iIndex);
        return true;
    }

    @Override
    public E set(int iIndex, E oElement) {
        E oResult = this._internalList.set(iIndex, oElement);
        this.fireContentsChanged(this, iIndex, iIndex);
        return oResult;
    }

    @Override
    public boolean removeAll(Collection<?> oCollection) {
        boolean bChanged = false;
        for (Object oElement : oCollection) {
            bChanged |= this.remove(oElement);
        }
        return bChanged;
    }

    @Override
    public boolean retainAll(Collection<?> oCollection) {
        boolean bResult = false;
        Iterator<E> iterElements = this.iterator();
        while (iterElements.hasNext()) {
            E oElement = iterElements.next();
            if (oCollection.contains(oElement)) continue;
            bResult = true;
            iterElements.remove();
        }
        return bResult;
    }

    @Override
    public ListModelAdapter<E> subList(int iFromIndex, int iToIndex) {
        return new SubListDecorator(this, iFromIndex, iToIndex);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorDecorator(this._internalList.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int iIndex) {
        return new ListIteratorDecorator(this._internalList.listIterator(iIndex));
    }

    @Override
    public boolean contains(Object o) {
        return this._internalList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._internalList.containsAll(c);
    }

    @Override
    public E get(int index) {
        return this._internalList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this._internalList.indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        return this._internalList.isEmpty();
    }

    @Override
    public int lastIndexOf(Object o) {
        return this._internalList.lastIndexOf(o);
    }

    @Override
    public int size() {
        return this._internalList.size();
    }

    @Override
    public Object[] toArray() {
        return this._internalList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._internalList.toArray(a);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ListModelAdapter)) {
            return false;
        }
        ListModelAdapter other = (ListModelAdapter)o;
        return ((Object)this._internalList).equals(other._internalList);
    }

    @Override
    public int hashCode() {
        int listHashCode = ((Object)this._internalList).hashCode();
        return listHashCode + 32768;
    }

    protected static class SubListDecorator<E>
    extends ListModelAdapter<E> {
        private static final long serialVersionUID = -3760181638551658142L;
        protected final int _offset;
        protected final ListModelAdapter<E> _parent;

        protected SubListDecorator(ListModelAdapter<E> parent, int fromIndex, int toIndex) {
            super(parent._internalList.subList(fromIndex, toIndex));
            this._parent = parent;
            this._offset = fromIndex;
        }

        @Override
        protected void fireContentsChanged(Object source, int index0, int index1) {
            super.fireContentsChanged(source, index0, index1);
            if (source == this && index0 >= 0 && index1 >= 0) {
                ((ListModelAdapter)this._parent).fireContentsChanged(this._parent, this._offset + index0, this._offset + index1);
            }
        }

        @Override
        protected void fireIntervalAdded(Object source, int index0, int index1) {
            super.fireIntervalAdded(source, index0, index1);
            if (source == this) {
                ((ListModelAdapter)this._parent).fireIntervalAdded(this._parent, this._offset + index0, this._offset + index1);
            }
        }

        @Override
        protected void fireIntervalRemoved(Object source, int index0, int index1) {
            super.fireIntervalRemoved(source, index0, index1);
            if (source == this) {
                ((ListModelAdapter)this._parent).fireIntervalRemoved(this._parent, this._offset + index0, this._offset + index1);
            }
        }
    }

    protected class ListIteratorDecorator
    implements ListIterator<E> {
        protected final ListIterator<E> _internalIterator;
        protected int _lastIndex;

        public ListIteratorDecorator(ListIterator<E> internalIterator) {
            this._internalIterator = internalIterator;
        }

        @Override
        public void add(E element) {
            this._internalIterator.add(element);
            int index = this._internalIterator.previousIndex();
            ListModelAdapter.this.fireIntervalAdded(ListModelAdapter.this, index, index);
        }

        @Override
        public void remove() {
            this._internalIterator.remove();
            int index = this._internalIterator.nextIndex();
            ListModelAdapter.this.fireIntervalRemoved(this, index, index);
        }

        @Override
        public void set(E element) {
            this._internalIterator.set(element);
            ListModelAdapter.this.fireContentsChanged(ListModelAdapter.this, this._lastIndex, this._lastIndex);
        }

        @Override
        public E next() {
            Object result = this._internalIterator.next();
            this._lastIndex = this._internalIterator.previousIndex();
            return result;
        }

        @Override
        public E previous() {
            Object result = this._internalIterator.previous();
            this._lastIndex = this._internalIterator.nextIndex();
            return result;
        }

        @Override
        public boolean hasNext() {
            return this._internalIterator.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this._internalIterator.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this._internalIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this._internalIterator.previousIndex();
        }
    }
}

