/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sf.javagimmicks.beans.BeanUtils;

public class ListTableModel<E>
extends AbstractList<E>
implements TableModel {
    private final Class<E> _rowType;
    private final List<Class<?>> _columnTypes;
    private final List<E> _rows;
    private final List<String> _indexToProperty;
    private final Map<String, Integer> _propertyToIndex;
    private List<String> _columnNames;
    private final List<TableModelListener> _listeners;

    public ListTableModel(Class<E> rowType) {
        this(null, rowType, null);
    }

    public ListTableModel(Class<E> rowType, List<String> indexToProperty) {
        this(null, rowType, indexToProperty);
    }

    public ListTableModel(List<E> rowdata, Class<E> rowType) {
        this(rowdata, rowType, null);
    }

    public ListTableModel(List<E> rowdata, Class<E> rowType, List<String> indexToProperty) {
        if (indexToProperty == null || indexToProperty.isEmpty()) {
            indexToProperty = BeanUtils.extractPropertyNames(rowType);
        }
        if (rowType == null || !rowType.isInterface()) {
            throw new IllegalArgumentException("Row type must be an interface!");
        }
        this._rowType = rowType;
        this._indexToProperty = indexToProperty;
        this._rows = rowdata != null ? rowdata : new ArrayList();
        this._listeners = new LinkedList<TableModelListener>();
        this._columnTypes = new ArrayList(this._indexToProperty.size());
        for (int i = 0; i < this._indexToProperty.size(); ++i) {
            try {
                this._columnTypes.add(this.getGetter(this._rowType, i).getReturnType());
                continue;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("No get-method for property '" + this._indexToProperty.get(i) + "' or method not accessible!");
            }
        }
        this._propertyToIndex = ListTableModel.getPropertyToIndexMap(this._indexToProperty);
        this._columnNames = this.getPropertyNames();
    }

    public Class<E> getRowType() {
        return this._rowType;
    }

    @Override
    public void add(int index, E element) {
        this._rows.add(index, element);
        this.fireRowAdded(index);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = this._rows.addAll(index, c);
        this.fireRowsAdded(index, index + c.size() - 1);
        return result;
    }

    @Override
    public void clear() {
        int size = this._rows.size();
        this._rows.clear();
        this.fireRowsRemoved(0, size - 1);
    }

    @Override
    public E get(int index) {
        RowInvocationHandler invocationHandler = new RowInvocationHandler(this._rows.get(index));
        return (E)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this._rowType}, (InvocationHandler)invocationHandler);
    }

    @Override
    public E remove(int index) {
        E result = this._rows.remove(index);
        this.fireRowRemoved(index);
        return result;
    }

    @Override
    public E set(int index, E element) {
        InvocationHandler handler;
        if (Proxy.isProxyClass(element.getClass()) && (handler = Proxy.getInvocationHandler(element)) instanceof RowInvocationHandler) {
            element = ((RowInvocationHandler)handler)._row;
        }
        E result = this._rows.set(index, element);
        this.fireRowChanged(index);
        return result;
    }

    @Override
    public int size() {
        return this._rows.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return this._indexToProperty.size();
    }

    @Override
    public int getRowCount() {
        return this._rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        try {
            E item = this._rows.get(rowIndex);
            return this.getGetter(item.getClass(), columnIndex).invoke(item, new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new Error("Unexpected exception while invoking internal get method!", e);
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        try {
            E item = this._rows.get(rowIndex);
            this.getSetter(item.getClass(), columnIndex).invoke(item, aValue);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new Error("Unexpected exception while invoking internal set method!", e);
        }
        this.fireCellChanged(rowIndex, columnIndex);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return BeanUtils.getWrapperType(this._columnTypes.get(columnIndex));
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this._columnNames.isEmpty() ? null : this._columnNames.get(columnIndex);
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this._listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this._listeners.remove(l);
    }

    public List<String> getPropertyNames() {
        return Collections.unmodifiableList(this._indexToProperty);
    }

    public List<String> getColmunNames() {
        return Collections.unmodifiableList(this._columnNames);
    }

    public void setColumnNames(List<String> columnNames) {
        if (columnNames == null || columnNames.isEmpty()) {
            this._columnNames = Collections.EMPTY_LIST;
        } else {
            if (columnNames.size() != this._indexToProperty.size()) {
                throw new IllegalArgumentException("Wrong number of column names! Expected: " + this._indexToProperty.size());
            }
            this._columnNames = new ArrayList<String>(columnNames);
        }
    }

    protected void fireRowsAdded(int fromIndex, int toIndex) {
        this.fireTableModelEvent(new TableModelEvent(this, fromIndex, toIndex, -1, 1));
    }

    protected void fireRowAdded(int rowIndex) {
        this.fireRowsAdded(rowIndex, rowIndex);
    }

    protected void fireRowsRemoved(int fromIndex, int toIndex) {
        this.fireTableModelEvent(new TableModelEvent(this, fromIndex, toIndex, -1, -1));
    }

    protected void fireRowRemoved(int rowIndex) {
        this.fireTableModelEvent(new TableModelEvent(this, rowIndex, rowIndex, -1, -1));
    }

    protected void fireCellChanged(int rowIndex, int columnIndex) {
        this.fireTableModelEvent(new TableModelEvent(this, rowIndex, rowIndex, columnIndex, 0));
    }

    protected void fireRowChanged(int rowIndex) {
        this.fireTableModelEvent(new TableModelEvent(this, rowIndex, rowIndex, -1, 0));
    }

    protected void fireTableModelEvent(TableModelEvent event) {
        for (TableModelListener l : this._listeners) {
            l.tableChanged(event);
        }
    }

    private Method getGetter(Class<?> itemClass, int columnIndex) throws SecurityException, NoSuchMethodException {
        String methodName = "get" + this._indexToProperty.get(columnIndex);
        return itemClass.getMethod(methodName, new Class[0]);
    }

    private Method getSetter(Class<?> itemClass, int columnIndex) throws SecurityException, NoSuchMethodException {
        String methodName = "set" + this._indexToProperty.get(columnIndex);
        return itemClass.getMethod(methodName, this._columnTypes.get(columnIndex));
    }

    private static Map<String, Integer> getPropertyToIndexMap(List<String> indexToProperty) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ListIterator<String> iterator = indexToProperty.listIterator();
        while (iterator.hasNext()) {
            result.put(iterator.next(), iterator.previousIndex());
        }
        return result;
    }

    private class RowInvocationHandler
    implements InvocationHandler {
        private final E _row;

        public RowInvocationHandler(E row) {
            this._row = row;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            int rowIndex;
            int columnIndex;
            method = this._row.getClass().getMethod(method.getName(), method.getParameterTypes());
            Object result = method.invoke(this._row, args);
            String methodName = method.getName();
            if (methodName.startsWith("set") && args.length == 1 && (columnIndex = this.getPropertyIndex(methodName.substring(3))) >= 0 && args[0].getClass().equals(ListTableModel.this._columnTypes.get(columnIndex)) && (rowIndex = ListTableModel.this._rows.indexOf(this._row)) >= 0) {
                ListTableModel.this.fireCellChanged(rowIndex, columnIndex);
            }
            return result;
        }

        private int getPropertyIndex(String propertyName) {
            Integer result = (Integer)ListTableModel.this._propertyToIndex.get(propertyName);
            return result != null ? result : -1;
        }
    }
}

