/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.javagimmicks.swing.model.ListTreeNode;

public class ListTreeModel<E>
implements TreeModel {
    protected final List<TreeModelListener> _listeners = new ArrayList<TreeModelListener>();
    protected final boolean _noChildrenMeansLeaf;
    protected ListTreeNode<E> _root;

    public ListTreeModel(boolean noChildrenMeansLeaf) {
        this._noChildrenMeansLeaf = noChildrenMeansLeaf;
    }

    public ListTreeModel() {
        this(false);
    }

    public ListTreeNode<E> createRoot(E value) {
        if (this._root != null) {
            throw new IllegalStateException("The model already has a root!");
        }
        this._root = new ListTreeNode<E>(this, false, value);
        return this._root;
    }

    public ListTreeNode<E> clear() {
        if (this._root == null) {
            return null;
        }
        ListTreeNode<E> result = this._root;
        this._root.updateModel(null);
        return result;
    }

    @Override
    public Object getChild(Object parent, int index) {
        ListTreeNode<E> simpleTreeNode = this.checkAndConvertToNode(parent);
        return simpleTreeNode.getChildAt(index);
    }

    @Override
    public int getChildCount(Object parent) {
        ListTreeNode<E> simpleTreeNode = this.checkAndConvertToNode(parent);
        return simpleTreeNode.getChildCount();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        ListTreeNode<E> simpleTreeNode = this.checkAndConvertToNode(parent);
        return simpleTreeNode.getChildListView().indexOf(child);
    }

    @Override
    public Object getRoot() {
        return this._root;
    }

    @Override
    public boolean isLeaf(Object node) {
        ListTreeNode<E> simpleTreeNode = this.checkAndConvertToNode(node);
        return this._noChildrenMeansLeaf ? simpleTreeNode.getChildCount() == 0 : !simpleTreeNode.getAllowsChildren();
    }

    @Override
    public void addTreeModelListener(TreeModelListener listener) {
        this._listeners.add(listener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        Object node = path.getLastPathComponent();
        ListTreeNode<Object> simpleTreeNode = this.checkAndConvertToNode(node);
        simpleTreeNode.setValue(newValue);
    }

    public List<ListTreeNode<E>> getPathToRootList(ListTreeNode<E> node) {
        if (node == null || node._model != this) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<ListTreeNode<ListTreeNode<E>>> result = new LinkedList<ListTreeNode<ListTreeNode<E>>>();
        while (node != null) {
            result.addFirst(node);
            node = node._parent;
        }
        return result;
    }

    public TreePath getPathToRoot(ListTreeNode<E> node) {
        return new TreePath(this.getPathToRootList(node).toArray());
    }

    protected void fireNodeChanged(ListTreeNode<E> parent, int index) {
        TreeModelEvent event = this.createTreeModelEvent(parent, index);
        for (TreeModelListener listener : this._listeners) {
            listener.treeNodesChanged(event);
        }
    }

    protected void fireNodesInserted(ListTreeNode<E> parent, int fromIndex, Collection<? extends ListTreeNode<E>> nodes) {
        TreeModelEvent event = this.createTreeModelEvent(parent, fromIndex, nodes);
        for (TreeModelListener listener : this._listeners) {
            listener.treeNodesInserted(event);
        }
    }

    protected void fireNodesRemoved(ListTreeNode<E> parent, int index, Collection<? extends ListTreeNode<E>> nodes) {
        TreeModelEvent event = this.createTreeModelEvent(parent, index, nodes);
        for (TreeModelListener listener : this._listeners) {
            listener.treeNodesRemoved(event);
        }
    }

    protected TreeModelEvent createTreeModelEvent(ListTreeNode<E> parent, int index) {
        return new TreeModelEvent((Object)this, this.getPathToRoot(parent), new int[]{index}, new Object[]{parent._children.get(index)});
    }

    protected TreeModelEvent createTreeModelEvent(ListTreeNode<E> parent, int fromIndex, Collection<? extends ListTreeNode<E>> nodes) {
        int[] indices = new int[nodes.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = fromIndex + i;
        }
        return new TreeModelEvent((Object)this, this.getPathToRoot(parent), indices, nodes.toArray());
    }

    private ListTreeNode<E> checkAndConvertToNode(Object o) {
        if (!(o instanceof ListTreeNode)) {
            throw new IllegalArgumentException("Provided node must be of type " + ListTreeNode.class.getName());
        }
        ListTreeNode simpleTreeNode = (ListTreeNode)o;
        if (simpleTreeNode._model != this) {
            throw new IllegalArgumentException("Provided node is not contained in this model");
        }
        return simpleTreeNode;
    }
}

