/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import net.sf.javagimmicks.swing.model.ListTreeModel;
import net.sf.javagimmicks.swing.model.ListTreeNode;

public class ListTreeModelBuilder<E> {
    protected final ListTreeModel<E> _model;
    protected ListTreeNode<E> _currentNode;
    protected ListTreeNode<E> _lastChild;

    public ListTreeModelBuilder(boolean noChildrenMeansLeaf) {
        this._model = new ListTreeModel(noChildrenMeansLeaf);
    }

    public ListTreeModelBuilder() {
        this._model = new ListTreeModel();
    }

    public ListTreeModelBuilder<E> child(E value) {
        if (this._currentNode == null && this._lastChild == null) {
            this._lastChild = this._model.createRoot(value);
        } else {
            if (this._currentNode == null) {
                throw new IllegalStateException("Can only add one child on the root level!");
            }
            this._lastChild = this._currentNode.addChild(value);
        }
        return this;
    }

    public ListTreeModelBuilder<E> children() {
        if (this._lastChild == null) {
            throw new IllegalStateException("No node created yet!");
        }
        this._currentNode = this._lastChild;
        this._lastChild = null;
        return this;
    }

    public ListTreeModelBuilder<E> parent() {
        if (this._currentNode == null) {
            throw new IllegalStateException("There is no parent on the root level!");
        }
        this._lastChild = this._currentNode;
        this._currentNode = this._currentNode.getParent();
        return this;
    }

    public ListTreeModel<E> buildModel() {
        return this._model;
    }
}

