/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import net.sf.javagimmicks.swing.model.ListTreeModel;

public class ListTreeNode<E>
implements TreeNode {
    protected ArrayList<ListTreeNode<E>> _children;
    protected ChildrenListView _childrenListView;
    protected ChildrenValueListView _childrenValueListView;
    protected ListTreeModel<E> _model;
    protected ListTreeNode<E> _parent;
    protected E _value;

    public ListTreeNode(E value, boolean leaf) {
        this(null, null, leaf, value);
    }

    protected ListTreeNode(ListTreeModel<E> model, boolean leaf, E value) {
        this(model, null, leaf, value);
    }

    protected ListTreeNode(ListTreeNode<E> parent, boolean leaf, E value) {
        this(parent._model, parent, leaf, value);
    }

    private ListTreeNode(ListTreeModel<E> model, ListTreeNode<E> parent, boolean leaf, E value) {
        this._model = model;
        this._parent = parent;
        this.setLeaf(leaf);
        this._value = value;
        this._childrenListView = new ChildrenListView();
        this._childrenValueListView = new ChildrenValueListView();
    }

    public ListTreeNode<E> addChildAt(int index, E value, boolean leaf) {
        ListTreeNode<E> result = new ListTreeNode<E>(value, leaf);
        this.getChildListView().add(index, result);
        return result;
    }

    public ListTreeNode<E> addChildAt(int index, E value) {
        return this.addChildAt(index, value, false);
    }

    public ListTreeNode<E> addChild(E value, boolean leaf) {
        return this.addChildAt(this.getChildCount(), value, leaf);
    }

    public ListTreeNode<E> addChild(E value) {
        return this.addChild(value, false);
    }

    public ListTreeNode<E> removeChildAt(int index) {
        return this.getChildListView().remove(index);
    }

    public List<ListTreeNode<E>> getChildListView() {
        return this._childrenListView;
    }

    public List<E> getChildValueListView() {
        return this._childrenValueListView;
    }

    public E getValue() {
        return this._value;
    }

    public void setValue(E value) {
        this._value = value;
        if (this._model != null) {
            this._model.fireNodeChanged(this._parent, this._parent == null ? 0 : this._parent._childrenListView.indexOf(this));
        }
    }

    public void setLeaf(boolean leaf) {
        if (this.isLeaf() == leaf) {
            return;
        }
        if (!leaf) {
            this._children = new ArrayList();
        } else if (this._children.isEmpty()) {
            this._children = null;
        } else {
            throw new IllegalStateException("Node still has children. Remove them before setting the node to leaf mode.");
        }
    }

    public Enumeration<ListTreeNode<E>> children() {
        return Collections.enumeration(this.isLeaf() ? Collections.EMPTY_LIST : this._children);
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    @Override
    public ListTreeNode<E> getChildAt(int childIndex) {
        if (!this.getAllowsChildren()) {
            throw new ArrayIndexOutOfBoundsException("Node allows no children!");
        }
        return this._children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.isLeaf() ? 0 : this._children.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.getAllowsChildren() ? this._children.indexOf(node) : -1;
    }

    @Override
    public ListTreeNode<E> getParent() {
        return this._parent;
    }

    @Override
    public boolean isLeaf() {
        return this._children == null;
    }

    public void detach() {
        if (this._parent == null && this._model == null) {
            throw new IllegalStateException("This node cannot be detached. It has no parent and is not a root node!");
        }
        if (this._parent != null) {
            this._parent._childrenListView.remove(this);
        } else if (this._model != null) {
            this.updateModel(null);
            this._model.fireNodesRemoved(null, 0, Collections.singleton(this));
        }
    }

    public String toString() {
        return this._value == null ? null : this._value.toString();
    }

    protected void updateModel(ListTreeModel<E> model) {
        this._model = model;
        if (!this.isLeaf()) {
            for (ListTreeNode<E> child : this._children) {
                child.updateModel(model);
            }
        }
    }

    protected class ChildrenValueListView
    extends AbstractList<E> {
        protected ChildrenValueListView() {
        }

        @Override
        public void add(int index, E element) {
            ListTreeNode newNode = new ListTreeNode(element, false);
            ListTreeNode.this._childrenListView.add(index, newNode);
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(ListTreeNode.this._childrenListView.size(), c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            ArrayList newNodeCollection = new ArrayList(c.size());
            for (Object element : c) {
                newNodeCollection.add(new ListTreeNode(element, false));
            }
            return ListTreeNode.this._childrenListView.addAll(index, newNodeCollection);
        }

        @Override
        public void clear() {
            ListTreeNode.this._childrenListView.clear();
        }

        @Override
        public E get(int index) {
            return ((ListTreeNode)ListTreeNode.this._childrenListView.get(index)).getValue();
        }

        @Override
        public E remove(int index) {
            return ((ListTreeNode)ListTreeNode.this._childrenListView.remove(index)).getValue();
        }

        @Override
        public E set(int index, E element) {
            Object childNode = ListTreeNode.this._childrenListView.get(index);
            Object oldValue = ((ListTreeNode)childNode).getValue();
            ((ListTreeNode)childNode).setValue(element);
            return oldValue;
        }

        @Override
        public int size() {
            return ListTreeNode.this._childrenListView.size();
        }
    }

    protected class ChildrenListView
    extends AbstractList<ListTreeNode<E>> {
        protected ChildrenListView() {
        }

        @Override
        public boolean addAll(int index, Collection<? extends ListTreeNode<E>> c) {
            this.checkLeaf();
            for (ListTreeNode newChild : c) {
                if (newChild._model != null) {
                    throw new IllegalArgumentException("Cannot add a node which already belongs to a model!");
                }
                if (newChild._parent != null) {
                    throw new IllegalArgumentException("Cannot add a non-detached node!");
                }
                newChild._parent = ListTreeNode.this;
                newChild.updateModel(ListTreeNode.this._model);
            }
            ListTreeNode.this._children.addAll(index, c);
            if (ListTreeNode.this._model != null) {
                ListTreeNode.this._model.fireNodesInserted(ListTreeNode.this, index, c);
            }
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends ListTreeNode<E>> c) {
            return this.addAll(ListTreeNode.this._children.size(), c);
        }

        @Override
        public void add(int index, ListTreeNode<E> element) {
            this.addAll(index, Collections.singleton(element));
        }

        @Override
        public void clear() {
            this.checkLeaf();
            this.clear(true);
        }

        private void clear(boolean isTop) {
            if (ListTreeNode.this.isLeaf()) {
                return;
            }
            for (ListTreeNode newChild : ListTreeNode.this._children) {
                newChild._childrenListView.clear(false);
                newChild._model = null;
                newChild._parent = null;
            }
            if (isTop && ListTreeNode.this._model != null) {
                ArrayList oldChildren = new ArrayList(ListTreeNode.this._children);
                ListTreeNode.this._children.clear();
                ListTreeNode.this._model.fireNodesRemoved(ListTreeNode.this, 0, oldChildren);
            } else {
                ListTreeNode.this._children.clear();
            }
        }

        @Override
        public ListTreeNode<E> get(int index) {
            this.checkLeaf();
            return ListTreeNode.this._children.get(index);
        }

        @Override
        public ListTreeNode<E> remove(int index) {
            this.checkLeaf();
            ListTreeNode removedNode = ListTreeNode.this._children.remove(index);
            removedNode.updateModel(null);
            removedNode._parent = null;
            if (ListTreeNode.this._model != null) {
                ListTreeNode.this._model.fireNodesRemoved(ListTreeNode.this, index, Collections.singleton(removedNode));
            }
            return removedNode;
        }

        @Override
        public ListTreeNode<E> set(int index, ListTreeNode<E> element) {
            this.checkLeaf();
            ListTreeNode result = ListTreeNode.this._children.set(index, element);
            if (ListTreeNode.this._model != null) {
                ListTreeNode.this._model.fireNodeChanged(ListTreeNode.this, index);
            }
            return result;
        }

        @Override
        public int size() {
            if (ListTreeNode.this.isLeaf()) {
                return 0;
            }
            return ListTreeNode.this._children.size();
        }

        private void checkLeaf() {
            if (ListTreeNode.this.isLeaf()) {
                throw new UnsupportedOperationException("Node is a leaf!");
            }
        }
    }
}

