/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.swing.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.text.Document;

public class OutputStreamDocumentAdapter
extends OutputStream {
    protected final Document _document;
    private final ByteArrayOutputStream _buffer = new ByteArrayOutputStream();

    public OutputStreamDocumentAdapter(Document document) {
        this._document = document;
    }

    @Override
    public void flush() throws IOException {
        try {
            this.applyText(this._document, this.harvestBuffer());
        }
        catch (Exception e) {
            throw new IOException("Unable to write into internal Document: " + e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this._buffer.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this._buffer.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this._buffer.write(b);
    }

    protected void applyText(Document document, String text) throws Exception {
        this._document.insertString(this._document.getLength(), text, null);
    }

    private String harvestBuffer() {
        byte[] arrBytes = this._buffer.toByteArray();
        this._buffer.reset();
        return new String(arrBytes);
    }
}

