/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.testing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.sf.javagimmicks.concurrent.CallableRunnableAdapter;
import net.sf.javagimmicks.lang.Factory;

public class MultiThreadedTestHelper<R> {
    private static String LINE_SEP = System.getProperty("line.separator");
    private List<Callable<R>> _workers = new LinkedList<Callable<R>>();
    private boolean _autoFail;

    public MultiThreadedTestHelper(boolean autoFail) {
        this._autoFail = autoFail;
    }

    public MultiThreadedTestHelper() {
        this(true);
    }

    public boolean isAutoFail() {
        return this._autoFail;
    }

    public void setAutoFail(boolean autoFail) {
        this._autoFail = autoFail;
    }

    public void addWorkers(Iterable<? extends Callable<R>> workers) {
        for (Callable<R> worker : workers) {
            if (worker == null) continue;
            this._workers.add(worker);
        }
    }

    public void addWorkers(int count, Iterable<Factory<? extends Callable<R>>> factories) {
        for (int i = 0; i < count; ++i) {
            for (Factory<Callable<R>> factory : factories) {
                Callable<R> worker;
                if (factory == null || (worker = factory.create()) == null) continue;
                this._workers.add(worker);
            }
        }
    }

    public void addWorkers(int count, Factory<? extends Callable<R>> ... factories) {
        this.addWorkers(count, Arrays.asList(factories));
    }

    public <F> TestResult<F, R> executeWorkers(Callable<F> mainWorker) throws AssertionError {
        return this.executeWorkers(mainWorker, new LatchWaitStrategy(){

            @Override
            public boolean await(CountDownLatch latch) throws InterruptedException {
                latch.await();
                return true;
            }
        });
    }

    public <F> TestResult<F, R> executeWorkers(Callable<F> mainWorker, final long timeout, final TimeUnit unit) throws AssertionError {
        return this.executeWorkers(mainWorker, new LatchWaitStrategy(){

            @Override
            public boolean await(CountDownLatch latch) throws InterruptedException, AssertionError {
                return latch.await(timeout, unit);
            }
        });
    }

    public TestResult<Void, R> executeWorkers(Runnable mainWorker) throws AssertionError {
        return this.executeWorkers(mainWorker != null ? new CallableRunnableAdapter(mainWorker) : (Callable)null);
    }

    public TestResult<Void, R> executeWorkers(Runnable mainWorker, long timeout, TimeUnit unit) throws AssertionError {
        return this.executeWorkers(mainWorker != null ? new CallableRunnableAdapter(mainWorker) : (Callable)null, timeout, unit);
    }

    public TestResult<Void, R> executeWorkers() throws AssertionError {
        return this.executeWorkers((Callable)null);
    }

    public TestResult<Void, R> executeWorkers(long timeout, TimeUnit unit) throws AssertionError {
        return this.executeWorkers((Callable)null, timeout, unit);
    }

    protected ExecutorService getExecutorService(int size) {
        return Executors.newFixedThreadPool(size);
    }

    private List<Worker<R>> setupWorkers(CountDownLatch latch) {
        ArrayList<Worker<R>> workers = new ArrayList<Worker<R>>(this._workers.size());
        for (Callable<R> workerCallable : this._workers) {
            workers.add(new Worker<R>(workerCallable, latch));
        }
        return workers;
    }

    private List<Future<WorkerResult<R>>> runAll(ExecutorService executor, List<Worker<R>> workers) {
        ArrayList<Future<WorkerResult<R>>> result = new ArrayList<Future<WorkerResult<R>>>(workers.size());
        for (Worker<R> worker : workers) {
            result.add(executor.submit(worker));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F> TestResult<F, R> executeWorkers(Callable<F> mainWorker, LatchWaitStrategy latchWaitStrategy) throws AssertionError {
        TestResult result;
        List<Future<WorkerResult<R>>> workerResults;
        block9: {
            int workerCount = this._workers.size();
            ExecutorService executor = this.getExecutorService(workerCount);
            CountDownLatch latch = new CountDownLatch(workerCount);
            List<Worker<R>> workers = this.setupWorkers(latch);
            workerResults = this.runAll(executor, workers);
            result = new TestResult();
            try {
                if (mainWorker != null) {
                    Object mainWorkerResult = new Worker<F>(mainWorker, null).call();
                    result.setMainWorkerResult(mainWorkerResult);
                }
                if (!result.isSuccess()) break block9;
                try {
                    if (!latchWaitStrategy.await(latch)) {
                        result._mainWorkerResult._assertionError = new AssertionError((Object)"Workers did not terminate within given time");
                    }
                }
                catch (InterruptedException e) {
                    result._mainWorkerResult._interruptedException = e;
                }
            }
            finally {
                if (!executor.isShutdown()) {
                    executor.shutdownNow();
                }
            }
        }
        this.addWorkerResults(result, workerResults);
        if (this._autoFail) {
            result.assertSuccessful();
        }
        return result;
    }

    private <F> void addWorkerResults(TestResult<F, R> result, List<Future<WorkerResult<R>>> results) throws AssertionError {
        ListIterator<Future<WorkerResult<R>>> iter = results.listIterator();
        while (iter.hasNext()) {
            Future<WorkerResult<R>> workerFuture = iter.next();
            if (!workerFuture.isDone()) continue;
            try {
                result.addWorkerResult(iter.previousIndex(), workerFuture.get());
            }
            catch (Exception e) {
                throw new AssertionError((Object)("Unexpected exception while getting worker results: " + e.toString()));
            }
        }
    }

    private static class Worker<R>
    implements Callable<WorkerResult<R>> {
        private final Callable<R> _delegate;
        private final CountDownLatch _latch;

        public Worker(Callable<R> delegate, CountDownLatch latch) {
            this._delegate = delegate;
            this._latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WorkerResult<R> call() {
            WorkerResult result = new WorkerResult();
            try {
                result._result = this._delegate.call();
            }
            catch (AssertionError e) {
                result._assertionError = e;
            }
            catch (Throwable t) {
                result._otherError = t;
            }
            finally {
                if (this._latch != null) {
                    this._latch.countDown();
                }
            }
            return result;
        }
    }

    private static interface LatchWaitStrategy {
        public boolean await(CountDownLatch var1) throws InterruptedException;
    }

    public static class TestResult<F, R> {
        protected WorkerResult<F> _mainWorkerResult = new WorkerResult();
        protected final SortedMap<Integer, WorkerResult<R>> _workerResults = new TreeMap<Integer, WorkerResult<R>>();
        protected final SortedMap<Integer, WorkerResult<R>> _failedWorkerResults = new TreeMap<Integer, WorkerResult<R>>();

        protected TestResult() {
        }

        public boolean isSuccess() {
            return this._mainWorkerResult.isSuccess() && this._failedWorkerResults.isEmpty();
        }

        public String buildFailMessage() {
            StringBuilder result = new StringBuilder();
            if (!this._mainWorkerResult.isSuccess()) {
                result.append("Main worker failed with reason: ").append(this._mainWorkerResult.buildFailMessage()).append(LINE_SEP);
            }
            for (Map.Entry<Integer, WorkerResult<R>> entry : this._failedWorkerResults.entrySet()) {
                result.append("Worker thread ").append(entry.getKey()).append(" failed with reason: ").append(entry.getValue().buildFailMessage()).append(LINE_SEP);
            }
            return result.toString();
        }

        public void assertSuccessful() throws AssertionError {
            if (!this.isSuccess()) {
                throw new AssertionError((Object)this.buildFailMessage());
            }
        }

        public WorkerResult<F> getMainWorkerResult() {
            return this._mainWorkerResult;
        }

        public SortedMap<Integer, WorkerResult<R>> getWorkerResults() {
            return Collections.unmodifiableSortedMap(this._workerResults);
        }

        public SortedMap<Integer, WorkerResult<R>> getFailedWorkerResults() {
            return Collections.unmodifiableSortedMap(this._failedWorkerResults);
        }

        protected void setMainWorkerResult(WorkerResult<F> mainWorkerResult) {
            this._mainWorkerResult = mainWorkerResult;
        }

        protected void addWorkerResult(int id, WorkerResult<R> result) {
            this._workerResults.put(id, result);
            if (!result.isSuccess()) {
                this._failedWorkerResults.put(id, result);
            }
        }
    }

    public static class WorkerResult<R> {
        protected AssertionError _assertionError;
        protected InterruptedException _interruptedException;
        protected Throwable _otherError;
        protected R _result;

        protected WorkerResult() {
        }

        public String buildFailMessage() {
            if (this._assertionError != null) {
                return ((Throwable)((Object)this._assertionError)).toString();
            }
            if (this._interruptedException != null) {
                return this._interruptedException.toString();
            }
            if (this._otherError != null) {
                return this._otherError.toString();
            }
            return null;
        }

        public AssertionError getAssertionError() {
            return this._assertionError;
        }

        public InterruptedException getInterruptedException() {
            return this._interruptedException;
        }

        public Throwable getOtherError() {
            return this._otherError;
        }

        public R getResult() {
            return this._result;
        }

        public boolean isSuccess() {
            return this._assertionError == null && this._interruptedException == null && this._otherError == null;
        }
    }
}

