/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sf.javagimmicks.collections.transformer.Transformer;
import net.sf.javagimmicks.collections.transformer.TransformerUtils;
import net.sf.javagimmicks.lang.Filter;

public class IncludeExcludePatternFilter
implements Filter<CharSequence> {
    private final List<Pattern> _includePatterns;
    private final List<Pattern> _excludePatterns;
    private static final Transformer<String, Pattern> _patternCompileTransformer = new Transformer<String, Pattern>(){

        @Override
        public Pattern transform(String regex) {
            return Pattern.compile(regex);
        }
    };

    public static IncludeExcludePatternFilter fromPatterns(Collection<Pattern> includePatterns, Collection<Pattern> excludePatterns) {
        return new IncludeExcludePatternFilter(new ArrayList<Pattern>(includePatterns), new ArrayList<Pattern>(excludePatterns));
    }

    public static IncludeExcludePatternFilter fromPatterns(Collection<Pattern> includePatterns) {
        Set<Pattern> excludePatterns = Collections.emptySet();
        return IncludeExcludePatternFilter.fromPatterns(includePatterns, excludePatterns);
    }

    public static IncludeExcludePatternFilter fromStringPatterns(Collection<String> includePatterns, Collection<String> excludePatterns) {
        return IncludeExcludePatternFilter.fromPatterns(TransformerUtils.decorate(includePatterns, _patternCompileTransformer), TransformerUtils.decorate(excludePatterns, _patternCompileTransformer));
    }

    public static IncludeExcludePatternFilter fromStringPatterns(Collection<String> includePatterns) {
        Set<String> excludePatterns = Collections.emptySet();
        return IncludeExcludePatternFilter.fromStringPatterns(includePatterns, excludePatterns);
    }

    public IncludeExcludePatternFilter() {
        this(new ArrayList<Pattern>(), new ArrayList<Pattern>());
    }

    private IncludeExcludePatternFilter(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        this._includePatterns = includePatterns;
        this._excludePatterns = excludePatterns;
    }

    public void addIncludePattern(Pattern pattern) {
        this._includePatterns.add(pattern);
    }

    public void addIncludePatterns(Collection<Pattern> patterns) {
        this._includePatterns.addAll(patterns);
    }

    public void addIncludePatternString(String pattern) {
        this._includePatterns.add(_patternCompileTransformer.transform(pattern));
    }

    public void addIncludePatternStrings(Collection<String> patterns) {
        this._includePatterns.addAll(TransformerUtils.decorate(patterns, _patternCompileTransformer));
    }

    public void addExcludePattern(Pattern pattern) {
        this._excludePatterns.add(pattern);
    }

    public void addExcludePatterns(Collection<Pattern> patterns) {
        this._excludePatterns.addAll(patterns);
    }

    public void addExcludePatternString(String pattern) {
        this._excludePatterns.add(_patternCompileTransformer.transform(pattern));
    }

    public void addExcludePatternStrings(Collection<String> patterns) {
        this._excludePatterns.addAll(TransformerUtils.decorate(patterns, _patternCompileTransformer));
    }

    public List<Pattern> getIncludePatterns() {
        return this._includePatterns;
    }

    public List<Pattern> getExcludePatterns() {
        return this._excludePatterns;
    }

    @Override
    public boolean accepts(CharSequence charSequence) {
        return (this._includePatterns.isEmpty() || IncludeExcludePatternFilter.matchesAny(this._includePatterns, charSequence)) && !IncludeExcludePatternFilter.matchesAny(this._excludePatterns, charSequence);
    }

    private static boolean matchesAny(List<Pattern> patterns, CharSequence charSequence) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(charSequence).matches()) continue;
            return true;
        }
        return false;
    }
}

