/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.javagimmicks.lang.WritableObjectContainer;

public class BlockingObjectContainer<E>
implements WritableObjectContainer<E> {
    protected final Lock _lock = new ReentrantLock();
    protected Condition _condition;
    protected E _instance;
    protected boolean _allowOverwrite;

    public BlockingObjectContainer(boolean allowOverwrite) {
        this._allowOverwrite = allowOverwrite;
    }

    public BlockingObjectContainer() {
        this(false);
    }

    public boolean isAllowOverwrite() {
        return this._allowOverwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(E instance) throws IllegalStateException {
        if (instance == null) {
            this.remove();
            return;
        }
        this._lock.lock();
        try {
            if (this._instance != null) {
                if (this._instance == instance) {
                    return;
                }
                if (!this.isAllowOverwrite()) {
                    throw new IllegalStateException("There is already an instance of " + instance.getClass().getName() + " registered! This may not be overwritten!");
                }
            }
            this._instance = instance;
            if (this._condition != null) {
                this._condition.signalAll();
                this._condition = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E remove() {
        this._lock.lock();
        try {
            E result = this._instance;
            this._instance = null;
            E e = result;
            return e;
        }
        finally {
            this._lock.unlock();
        }
    }

    public E get() {
        try {
            return this.get(new WaitStrategy(){

                @Override
                public void await(Condition condition) {
                    condition.awaitUninterruptibly();
                }
            });
        }
        catch (InterruptedException cannotOccur) {
            return null;
        }
    }

    public E getInterruptibly() throws InterruptedException {
        return this.get(new WaitStrategy(){

            @Override
            public void await(Condition condition) throws InterruptedException {
                condition.await();
            }
        });
    }

    public E get(final long time, final TimeUnit timeUnit) throws InterruptedException {
        return this.get(new WaitStrategy(){

            @Override
            public void await(Condition condition) throws InterruptedException {
                condition.await(time, timeUnit);
            }
        });
    }

    public E getNoWait() {
        return this._instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E get(WaitStrategy waitStrategy) throws InterruptedException {
        this._lock.lock();
        try {
            if (this._instance == null) {
                if (this._condition == null) {
                    this._condition = this._lock.newCondition();
                }
                waitStrategy.await(this._condition);
            }
            E e = this._instance;
            return e;
        }
        finally {
            this._lock.unlock();
        }
    }

    private static interface WaitStrategy {
        public void await(Condition var1) throws InterruptedException;
    }
}

