/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.concurrent;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.sf.javagimmicks.concurrent.BlockingObjectContainer;
import net.sf.javagimmicks.lang.WritableObjectContainer;

public class BlockingSingletonRegistry {
    private static BlockingSingletonRegistry _defaultInstance;
    private final Map<Class<?>, BlockingObjectContainer<?>> _theContainers = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BlockingSingletonRegistry getDefault() {
        if (_defaultInstance != null) {
            return _defaultInstance;
        }
        Class<BlockingSingletonRegistry> clazz = BlockingSingletonRegistry.class;
        synchronized (BlockingSingletonRegistry.class) {
            if (_defaultInstance == null) {
                _defaultInstance = new BlockingSingletonRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _defaultInstance;
        }
    }

    public <T> void set(T instance) throws IllegalStateException {
        if (instance == null) {
            return;
        }
        Class<?> clazz = instance.getClass();
        this.getOrCreateContainer(clazz).set(instance);
    }

    public <T> void remove(Class<T> clazz) {
        if (clazz == null) {
            return;
        }
        WritableObjectContainer container = this._theContainers.remove(clazz);
        if (container != null) {
            container.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void remove(T instance) {
        if (instance == null) {
            return;
        }
        Class<?> clazz = instance.getClass();
        Map<Class<?>, BlockingObjectContainer<?>> map = this._theContainers;
        synchronized (map) {
            BlockingObjectContainer<?> container = this._theContainers.get(clazz);
            if (container == null) {
                return;
            }
            Object existingInstance = container.getNoWait();
            if (existingInstance != null && existingInstance != instance) {
                throw new IllegalArgumentException("There is another instance of " + clazz.getName() + " registered! Are you sure it is a singleton?");
            }
            container.remove();
            this._theContainers.remove(clazz);
        }
    }

    public <T> T get(Class<T> clazz) {
        return this.getOrCreateContainer(clazz).get();
    }

    public <T> T getInterruptibly(Class<T> clazz) throws InterruptedException {
        return this.getOrCreateContainer(clazz).getInterruptibly();
    }

    public <T> T get(Class<T> clazz, long time, TimeUnit timeUnit) throws InterruptedException {
        return this.getOrCreateContainer(clazz).get(time, timeUnit);
    }

    public <T> T getNoWait(Class<T> clazz) {
        return this.getOrCreateContainer(clazz).getNoWait();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E> BlockingObjectContainer<E> getOrCreateContainer(Class<E> clazz) {
        BlockingObjectContainer<Object> result = this._theContainers.get(clazz);
        if (result != null) {
            return result;
        }
        Map<Class<?>, BlockingObjectContainer<?>> map = this._theContainers;
        synchronized (map) {
            result = this._theContainers.get(clazz);
            if (result == null) {
                result = new BlockingObjectContainer();
                this._theContainers.put(clazz, result);
            }
            return result;
        }
    }
}

