/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.concurrent.locks;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import net.sf.javagimmicks.concurrent.locks.LockRegistry;
import net.sf.javagimmicks.lang.Factory;

class DefaultLockRegistry<K>
implements LockRegistry<K>,
Serializable {
    private static final long serialVersionUID = -785304313135882910L;
    private static final Factory<Collection<Thread>> HASHSET_SHARED_COLLECTION_FACTORY = new HashSetSharedCollectionFactory();
    protected final Map<K, Thread> _exRegistry;
    protected final Map<K, Collection<Thread>> _shRegistry;
    protected final Factory<Collection<Thread>> _shCollectionFactory;

    public static <K> DefaultLockRegistry<K> createHashBasedInstance() {
        return new DefaultLockRegistry(new HashMap(), new HashMap(), HASHSET_SHARED_COLLECTION_FACTORY);
    }

    public static <K> DefaultLockRegistry<K> createTreeBasedInstance() {
        return new DefaultLockRegistry(new TreeMap(), new TreeMap(), HASHSET_SHARED_COLLECTION_FACTORY);
    }

    public DefaultLockRegistry(Map<K, Thread> exRegistry, Map<K, Collection<Thread>> shRegistry, Factory<Collection<Thread>> sharedCollectionFactory) {
        this._exRegistry = exRegistry;
        this._shRegistry = shRegistry;
        this._shCollectionFactory = sharedCollectionFactory;
    }

    @Override
    public boolean isSharedFree(Collection<K> resources) {
        for (K resource : resources) {
            if (!this._shRegistry.containsKey(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void registerShared(Collection<K> resources) {
        Thread currentThread = Thread.currentThread();
        for (K resource : resources) {
            Collection threadsForResource = this._shRegistry.get(resource);
            if (threadsForResource == null) {
                threadsForResource = (Collection)this._shCollectionFactory.create();
                this._shRegistry.put(resource, threadsForResource);
            }
            threadsForResource.add((Thread)currentThread);
        }
    }

    @Override
    public void unregisterShared(Collection<K> resources) {
        Thread currentThread = Thread.currentThread();
        for (K resource : resources) {
            Collection<Thread> threadsForResource = this._shRegistry.get(resource);
            if (threadsForResource == null) continue;
            threadsForResource.remove(currentThread);
            if (!threadsForResource.isEmpty()) continue;
            this._shRegistry.remove(resource);
        }
    }

    @Override
    public boolean isExclusiveFree(Collection<K> resources) {
        for (K resource : resources) {
            if (!this._exRegistry.containsKey(resource)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void registerExclusive(Collection<K> resources) {
        Thread currentThread = Thread.currentThread();
        for (K resource : resources) {
            this._exRegistry.put(resource, currentThread);
        }
    }

    @Override
    public void unregisterExclusive(Collection<K> resources) {
        for (K resource : resources) {
            this._exRegistry.remove(resource);
        }
    }

    private static final class HashSetSharedCollectionFactory
    implements Factory<Collection<Thread>>,
    Serializable {
        private static final long serialVersionUID = 3613642441786733902L;

        private HashSetSharedCollectionFactory() {
        }

        public Collection<Thread> create() {
            return new HashSet<Thread>();
        }
    }
}

