/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.concurrent.locks;

import net.sf.javagimmicks.concurrent.locks.DefaultLockRegistry;
import net.sf.javagimmicks.concurrent.locks.LockRegistry;
import net.sf.javagimmicks.concurrent.locks.MultiLockProvider;
import net.sf.javagimmicks.concurrent.locks.RegistryLockProvider;
import net.sf.javagimmicks.lang.Factory;

public class MultiLockProviderFactory<K>
implements Factory<MultiLockProvider<K>> {
    private static final MultiLockProviderFactory<Object> HASH_INSTANCE = new MultiLockProviderFactory(new HashLockRegistryFactory());
    private static final MultiLockProviderFactory<Object> TREE_INSTANCE = new MultiLockProviderFactory(new TreeLockRegistryFactory());
    private final Factory<LockRegistry<K>> _registryFactory;

    public static <K> MultiLockProviderFactory<K> getHashBasedInstance() {
        return HASH_INSTANCE;
    }

    public static <K> MultiLockProviderFactory<K> getTreeBasedInstance() {
        return TREE_INSTANCE;
    }

    private MultiLockProviderFactory(Factory<LockRegistry<K>> registryFactory) {
        this._registryFactory = registryFactory;
    }

    public MultiLockProvider<K> create() {
        return new RegistryLockProvider((LockRegistry)this._registryFactory.create());
    }

    private static class TreeLockRegistryFactory<K>
    implements Factory<LockRegistry<K>> {
        private TreeLockRegistryFactory() {
        }

        public LockRegistry<K> create() {
            return DefaultLockRegistry.createTreeBasedInstance();
        }
    }

    private static class HashLockRegistryFactory<K>
    implements Factory<LockRegistry<K>> {
        private HashLockRegistryFactory() {
        }

        public LockRegistry<K> create() {
            return DefaultLockRegistry.createHashBasedInstance();
        }
    }
}

