/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.util8;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class IncludeExcludePatternPredicate
implements Predicate<CharSequence> {
    private final List<Pattern> _includePatterns;
    private final List<Pattern> _excludePatterns;

    public static IncludeExcludePatternPredicate fromPatterns(Collection<Pattern> includePatterns, Collection<Pattern> excludePatterns) {
        return new IncludeExcludePatternPredicate(new ArrayList<Pattern>(includePatterns), new ArrayList<Pattern>(excludePatterns));
    }

    public static IncludeExcludePatternPredicate fromPatterns(Collection<Pattern> includePatterns) {
        Set<Pattern> excludePatterns = Collections.emptySet();
        return IncludeExcludePatternPredicate.fromPatterns(includePatterns, excludePatterns);
    }

    public static IncludeExcludePatternPredicate fromStringPatterns(Collection<String> includePatterns, Collection<String> excludePatterns) {
        return IncludeExcludePatternPredicate.fromPatterns(IncludeExcludePatternPredicate.bulkCompile(includePatterns), IncludeExcludePatternPredicate.bulkCompile(excludePatterns));
    }

    public static IncludeExcludePatternPredicate fromStringPatterns(Collection<String> includePatterns) {
        Set<String> excludePatterns = Collections.emptySet();
        return IncludeExcludePatternPredicate.fromStringPatterns(includePatterns, excludePatterns);
    }

    public IncludeExcludePatternPredicate() {
        this(new ArrayList<Pattern>(), new ArrayList<Pattern>());
    }

    private IncludeExcludePatternPredicate(List<Pattern> includePatterns, List<Pattern> excludePatterns) {
        this._includePatterns = includePatterns;
        this._excludePatterns = excludePatterns;
    }

    public void addIncludePatterns(Collection<Pattern> patterns) {
        this._includePatterns.addAll(patterns);
    }

    public void addIncludePatterns(Pattern ... patterns) {
        this.addIncludePatterns(Arrays.asList(patterns));
    }

    public void addIncludePatternStrings(Collection<String> patterns) {
        this._includePatterns.addAll(IncludeExcludePatternPredicate.bulkCompile(patterns));
    }

    public void addIncludePatterns(String ... patterns) {
        this.addIncludePatternStrings(Arrays.asList(patterns));
    }

    public void addExcludePatterns(Collection<Pattern> patterns) {
        this._excludePatterns.addAll(patterns);
    }

    public void addExcludePatterns(Pattern ... patterns) {
        this.addExcludePatterns(Arrays.asList(patterns));
    }

    public void addExcludePatternStrings(Collection<String> patterns) {
        this._excludePatterns.addAll(IncludeExcludePatternPredicate.bulkCompile(patterns));
    }

    public void addExcludePatterns(String ... patterns) {
        this.addExcludePatternStrings(Arrays.asList(patterns));
    }

    public List<Pattern> getIncludePatterns() {
        return Collections.unmodifiableList(this._includePatterns);
    }

    public List<Pattern> getExcludePatterns() {
        return Collections.unmodifiableList(this._excludePatterns);
    }

    @Override
    public boolean test(CharSequence charSequence) {
        return (this._includePatterns.isEmpty() || IncludeExcludePatternPredicate.matchesAny(this._includePatterns, charSequence)) && !IncludeExcludePatternPredicate.matchesAny(this._excludePatterns, charSequence);
    }

    private static boolean matchesAny(List<Pattern> patterns, CharSequence charSequence) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(charSequence).matches()) continue;
            return true;
        }
        return false;
    }

    private static Set<Pattern> bulkCompile(Collection<String> patterns) {
        HashSet<Pattern> result = new HashSet<Pattern>();
        for (String pattern : patterns) {
            result.add(Pattern.compile(pattern));
        }
        return result;
    }
}

