/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.util8;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;

public class ReflectionSupplier<E>
implements Supplier<E> {
    protected final Constructor<? extends E> _constructor;
    protected final Supplier<Object[]> _argSupplier;
    private static final Supplier<Object[]> EMPTY_ARG_FACTORY = new Supplier<Object[]>(){

        @Override
        public Object[] get() {
            return new Object[0];
        }
    };

    public ReflectionSupplier(Constructor<? extends E> constructor, Supplier<Object[]> argSupplier) throws IllegalArgumentException, SecurityException {
        Class<E> declaringClass = constructor.getDeclaringClass();
        if (Modifier.isAbstract(declaringClass.getModifiers())) {
            throw new IllegalArgumentException("The given contructor belongs to an abstract class: " + declaringClass.getName());
        }
        if (!Modifier.isPublic(constructor.getModifiers())) {
            throw new IllegalArgumentException("Contructor must be public and accessible!");
        }
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        for (Class<?> exceptionClass : constructor.getExceptionTypes()) {
            if (RuntimeException.class.isAssignableFrom(exceptionClass) || Error.class.isAssignableFrom(exceptionClass)) continue;
            throw new IllegalArgumentException("The given constructor can throw an Exception of type " + exceptionClass + " which is a checked Exception!");
        }
        this._constructor = constructor;
        this._argSupplier = argSupplier != null ? argSupplier : EMPTY_ARG_FACTORY;
    }

    public ReflectionSupplier(Class<? extends E> type, Class<?>[] argTypes, Supplier<Object[]> argSupplier) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        this(type.getConstructor(argTypes), argSupplier);
    }

    public ReflectionSupplier(Class<? extends E> type) throws IllegalArgumentException, SecurityException, NoSuchMethodException {
        this(type, new Class[0], null);
    }

    @Override
    public final E get() {
        try {
            return this._constructor.newInstance(this._argSupplier.get());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("The invoked clone() method is not accessible", e);
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable originalThrowable = e.getTargetException();
            if (originalThrowable instanceof Error) {
                throw (Error)originalThrowable;
            }
            if (originalThrowable instanceof RuntimeException) {
                throw (RuntimeException)originalThrowable;
            }
            return null;
        }
    }
}

