/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.sql.testing;

import java.io.File;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.hsqldb.jdbcDriver;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public class HsqlDbTestRule
extends ExternalResource {
    public static final String NAME_TEST_DB = "test-db";
    private final TemporaryFolder _folderRule;
    private final DataSourceConfigurator _configurator;
    private BasicDataSource _dataSource;

    public HsqlDbTestRule(DataSourceConfigurator configurator, File dbFolder) {
        this._configurator = configurator;
        this._folderRule = new TemporaryFolder(dbFolder);
    }

    public HsqlDbTestRule(DataSourceConfigurator configurator) {
        this(configurator, null);
    }

    public HsqlDbTestRule(File dbFolder) {
        this(null, dbFolder);
    }

    public HsqlDbTestRule() {
        this(null, null);
    }

    public BasicDataSource getDataSource() {
        return this._dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public File getDatabaseFolder() {
        return this._folderRule.getRoot();
    }

    public void init() throws Throwable {
        this.before();
    }

    public void shutdown() {
        this.after();
    }

    protected void before() throws Throwable {
        this._folderRule.create();
        File tempFolder = this._folderRule.getRoot();
        this._dataSource = new BasicDataSource();
        this._dataSource.setDriverClassName(jdbcDriver.class.getName());
        this._dataSource.setUrl(HsqlDbTestRule.buildJdbcUrl(tempFolder));
        this._dataSource.setUsername("sa");
        this._dataSource.setPassword("");
        if (this._configurator != null) {
            this._configurator.configure(this._dataSource);
        }
    }

    protected void after() {
        try {
            this._dataSource.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._dataSource = null;
        this._folderRule.delete();
    }

    private static String buildJdbcUrl(File tempFolder) throws MalformedURLException {
        String url = "jdbc:hsqldb:" + tempFolder.toURI().toURL() + NAME_TEST_DB;
        return url;
    }

    public static interface DataSourceConfigurator {
        public void configure(BasicDataSource var1);
    }
}

