/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.sql.testing;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;

public abstract class AbstractDbTestRule
extends ExternalResource {
    public static final String NAME_TEST_DB = "test-db";
    private final TemporaryFolder _folderRule;
    private final DataSourceConfigurator _configurator;
    private BasicDataSource _dataSource;

    protected AbstractDbTestRule(DataSourceConfigurator configurator, File dbFolder) {
        this._configurator = configurator;
        this._folderRule = new TemporaryFolder(dbFolder);
    }

    protected AbstractDbTestRule(DataSourceConfigurator configurator) {
        this(configurator, null);
    }

    protected AbstractDbTestRule(File dbFolder) {
        this(null, dbFolder);
    }

    protected AbstractDbTestRule() {
        this(null, null);
    }

    public BasicDataSource getDataSource() {
        return this._dataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public File getDatabaseFolder() {
        return this._folderRule.getRoot();
    }

    public void init() throws Throwable {
        this.before();
    }

    public void shutdown() {
        this.after();
    }

    protected void before() throws Throwable {
        this._folderRule.create();
        File tempFolder = this._folderRule.getRoot();
        this._dataSource = new BasicDataSource();
        this.configureDatasource(this._dataSource, tempFolder);
        if (this._configurator != null) {
            this._configurator.configure(this._dataSource);
        }
    }

    protected void after() {
        try {
            this._dataSource.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._dataSource = null;
        this._folderRule.delete();
    }

    protected abstract void configureDatasource(BasicDataSource var1, File var2) throws Exception;

    public static interface DataSourceConfigurator {
        public void configure(BasicDataSource var1);
    }
}

