/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.sql.testing;

import java.io.File;
import java.net.MalformedURLException;
import net.sf.javagimmicks.sql.testing.AbstractDbTestRule;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.derby.jdbc.EmbeddedDriver;

public class DerbyDbTestRule
extends AbstractDbTestRule {
    public DerbyDbTestRule(AbstractDbTestRule.DataSourceConfigurator configurator, File dbFolder) {
        super(configurator, dbFolder);
    }

    public DerbyDbTestRule(AbstractDbTestRule.DataSourceConfigurator configurator) {
        super(configurator);
    }

    public DerbyDbTestRule(File dbFolder) {
        super(dbFolder);
    }

    public DerbyDbTestRule() {
    }

    @Override
    protected void configureDatasource(BasicDataSource dataSource, File tempFolder) throws MalformedURLException {
        dataSource.setDriverClassName(EmbeddedDriver.class.getName());
        dataSource.setUrl(DerbyDbTestRule.buildJdbcUrl(tempFolder));
    }

    private static String buildJdbcUrl(File tempFolder) throws MalformedURLException {
        StringBuilder url = new StringBuilder("jdbc:derby:");
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            url.append(tempFolder.toURI().toURL().toString().substring(6));
        } else {
            url.append(tempFolder.toURI().toURL().toString().substring(5));
        }
        url.append("test-db").append(";create=true");
        return url.toString();
    }
}

