/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.sql.testing;

import java.io.File;
import java.net.MalformedURLException;
import net.sf.javagimmicks.sql.testing.AbstractDbTestRule;
import org.apache.commons.dbcp.BasicDataSource;
import org.h2.Driver;

public class H2DbTestRule
extends AbstractDbTestRule {
    public H2DbTestRule(AbstractDbTestRule.DataSourceConfigurator configurator, File dbFolder) {
        super(configurator, dbFolder);
    }

    public H2DbTestRule(AbstractDbTestRule.DataSourceConfigurator configurator) {
        super(configurator);
    }

    public H2DbTestRule(File dbFolder) {
        super(dbFolder);
    }

    public H2DbTestRule() {
    }

    @Override
    protected void configureDatasource(BasicDataSource dataSource, File tempFolder) throws MalformedURLException {
        dataSource.setDriverClassName(Driver.class.getName());
        dataSource.setUrl(H2DbTestRule.buildJdbcUrl(tempFolder));
        dataSource.setUsername("sa");
        dataSource.setPassword("sa");
    }

    private static String buildJdbcUrl(File tempFolder) throws MalformedURLException {
        String url = "jdbc:h2:" + tempFolder.toURI().toURL() + "test-db";
        return url;
    }
}

