/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javagimmicks.sql.testing;

import java.io.File;
import java.net.MalformedURLException;
import net.sf.javagimmicks.sql.testing.AbstractDbTestRule;
import org.apache.commons.dbcp.BasicDataSource;
import org.hsqldb.jdbcDriver;

public class HsqlDbTestRule
extends AbstractDbTestRule {
    public HsqlDbTestRule(AbstractDbTestRule.DataSourceConfigurator configurator, File dbFolder) {
        super(configurator, dbFolder);
    }

    public HsqlDbTestRule(AbstractDbTestRule.DataSourceConfigurator configurator) {
        super(configurator);
    }

    public HsqlDbTestRule(File dbFolder) {
        super(dbFolder);
    }

    public HsqlDbTestRule() {
    }

    @Override
    protected void configureDatasource(BasicDataSource dataSource, File tempFolder) throws MalformedURLException {
        dataSource.setDriverClassName(jdbcDriver.class.getName());
        dataSource.setUrl(HsqlDbTestRule.buildJdbcUrl(tempFolder));
        dataSource.setUsername("sa");
        dataSource.setPassword("");
    }

    private static String buildJdbcUrl(File tempFolder) throws MalformedURLException {
        String url = "jdbc:hsqldb:" + tempFolder.toURI().toURL() + "test-db";
        return url;
    }
}

