/*
 * Decompiled with CFR 0.152.
 */
package phat.mobile.servicemanager.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import phat.mobile.servicemanager.CommonVars;
import phat.mobile.servicemanager.ServiceManager;
import phat.mobile.servicemanager.messages.ErrorMessage;
import phat.mobile.servicemanager.messages.RegisterServiceMessageImpl;
import phat.mobile.servicemanager.messages.RequestServiceImpl;
import phat.mobile.servicemanager.services.Service;

public class ServiceManagerRemote
implements ServiceManager {
    private int port;
    private String ip;
    private String mobileName;
    private static ServiceManagerRemote serviceManagerRemote;

    public static ServiceManagerRemote getInstance() {
        if (serviceManagerRemote == null) {
            serviceManagerRemote = new ServiceManagerRemote();
        }
        return serviceManagerRemote;
    }

    private ServiceManagerRemote() {
        System.out.println("ServiceManagerRemote()");
        Properties prop = CommonVars.getPorperties();
        System.out.println("prop = " + prop);
        if (prop != null) {
            this.ip = (String)prop.get("sms_ip");
            this.port = Integer.parseInt((String)prop.get("sms_port"));
            this.mobileName = (String)prop.get("deviceName");
            System.out.println("ServiceManagerRemote(" + this.mobileName + "," + this.ip + ":" + this.port);
        }
    }

    public void registerService(String serviceSetId, Service service) {
        Socket socket = null;
        try {
            socket = new Socket(this.ip, this.port);
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            RegisterServiceMessageImpl rsm = new RegisterServiceMessageImpl(this.mobileName, service);
            oos.writeObject(rsm);
            oos.flush();
            oos.close();
            socket.close();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Service getService(String serviceSetId, String serviceTypeName) {
        Socket socket = null;
        try {
            System.out.println("getService(" + serviceSetId + "," + serviceTypeName + ")");
            System.out.println("new Socket(" + this.ip + "," + this.port + ")");
            socket = new Socket(this.ip, this.port);
            System.out.println("socket = " + socket);
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            System.out.println("oos = " + socket);
            RequestServiceImpl rs = new RequestServiceImpl(this.mobileName, serviceTypeName);
            System.out.println("RequestService(" + this.mobileName + "," + serviceTypeName + ") " + rs);
            oos.writeObject(rs);
            System.out.println("write rs");
            oos.flush();
            System.out.println("flush");
            ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
            System.out.println("ois");
            Object answer = ois.readObject();
            System.out.println("answer");
            if (answer instanceof ErrorMessage) {
                ErrorMessage em = (ErrorMessage)answer;
                System.out.println("Error: " + em.getMessage());
            } else if (answer instanceof Service) {
                Service service = (Service)answer;
                System.out.println("Service gotten: " + service.getIp() + ":" + service.getPort() + ", type = " + service.getType());
                return service;
            }
            ois.close();
            oos.close();
            socket.close();
        }
        catch (UnknownHostException e) {
            System.out.println("UnknownHostException");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("IOException");
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            System.out.println("ClassNotFoundException");
            e.printStackTrace();
        }
        return null;
    }

    public List<String> getServiceSetIds() {
        return null;
    }
}

