/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguiraffe.gui.platform.javafx.builder.components;

import javafx.scene.Node;
import javafx.scene.control.Control;
import net.sf.jguiraffe.gui.builder.components.ComponentBuilderCallBack;
import net.sf.jguiraffe.gui.builder.components.ComponentBuilderData;
import net.sf.jguiraffe.gui.builder.components.Composite;
import net.sf.jguiraffe.gui.builder.components.tags.ComponentBaseTag;
import net.sf.jguiraffe.gui.builder.components.tags.FontTag;
import net.sf.jguiraffe.gui.builder.components.tags.FormBaseTag;
import net.sf.jguiraffe.gui.builder.components.tags.ScrollSizeSupport;
import net.sf.jguiraffe.gui.layout.UnitSizeHandler;
import net.sf.jguiraffe.gui.platform.javafx.builder.NodeProperties;
import net.sf.jguiraffe.gui.platform.javafx.builder.components.package$;
import net.sf.jguiraffe.gui.platform.javafx.layout.JavaFxUnitSizeHandler$;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.lang.StringUtils;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class JavaFxComponentManager$ {
    public static final JavaFxComponentManager$ MODULE$;
    private final String FontStyleNormal;
    private final String FontStyleItalic;
    private final String FontWeightBold;

    static {
        new JavaFxComponentManager$();
    }

    private String FontStyleNormal() {
        return this.FontStyleNormal;
    }

    private String FontStyleItalic() {
        return this.FontStyleItalic;
    }

    private String FontWeightBold() {
        return this.FontWeightBold;
    }

    public void net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$initNode(ComponentBaseTag tag, Node node) {
        if (StringUtils.isNotEmpty((String)tag.getName())) {
            node.setId(tag.getName());
        }
        NodeProperties properties = new NodeProperties(tag.getBackgroundColor(), tag.getForegroundColor(), tag.getFont());
        package$.MODULE$.initNodeProperties(node, properties);
    }

    public UnitSizeHandler fetchSizeHandler(TagSupport tag) {
        return JavaFxUnitSizeHandler$.MODULE$.fromContext(tag.getContext());
    }

    public UnitSizeHandler installSizeHandler(TagSupport tag, UnitSizeHandler handler) {
        return JavaFxUnitSizeHandler$.MODULE$.storeSizeHandler(tag.getContext(), handler);
    }

    public Option<String> net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$convertFontFamily(FontTag tag) {
        return tag.getName() == null ? None$.MODULE$ : new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'\"'), tag.getName(), BoxesRunTime.boxToCharacter((char)'\"')})));
    }

    public Option<String> net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$convertFontSize(FontTag tag) {
        int size = tag.getSize();
        return size > 0 ? new Some((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "px"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)size)}))) : None$.MODULE$;
    }

    public Option<String> net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$convertFontStyle(FontTag tag) {
        return new Some((Object)(tag.isItalic() ? this.FontStyleItalic() : this.FontStyleNormal()));
    }

    public Option<String> net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$convertFontWeight(FontTag tag) {
        return new Some((Object)(tag.isBold() ? this.FontWeightBold() : this.FontStyleNormal()));
    }

    public ComponentBuilderData net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$fetchBuilderData(Tag tag) {
        return ComponentBuilderData.get((JellyContext)tag.getContext());
    }

    public void net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$initScrollSize(FormBaseTag tag, Control ctrl) {
        UnitSizeHandler sizeHandler = this.fetchSizeHandler((TagSupport)tag);
        Composite composite = this.currentContainerTag(tag);
        this.net$sf$jguiraffe$gui$platform$javafx$builder$components$JavaFxComponentManager$$fetchBuilderData((Tag)tag).addCallBack(new ComponentBuilderCallBack(tag, ctrl, sizeHandler, composite){
            private final FormBaseTag tag$1;
            private final Control ctrl$1;
            private final UnitSizeHandler sizeHandler$1;
            private final Composite composite$1;

            public void callBack(ComponentBuilderData builderData, Object params) {
                Object container = this.composite$1.getContainer();
                int xSize = ((ScrollSizeSupport)this.tag$1).getPreferredScrollWidth().toPixel(this.sizeHandler$1, container, false);
                int ySize = ((ScrollSizeSupport)this.tag$1).getPreferredScrollHeight().toPixel(this.sizeHandler$1, container, true);
                if (xSize > 0) {
                    this.ctrl$1.setPrefWidth((double)xSize);
                }
                if (ySize > 0) {
                    this.ctrl$1.setPrefHeight((double)ySize);
                }
            }
            {
                this.tag$1 = tag$1;
                this.ctrl$1 = ctrl$1;
                this.sizeHandler$1 = sizeHandler$1;
                this.composite$1 = composite$1;
            }
        }, null);
    }

    private Composite currentContainerTag(FormBaseTag tag) {
        return tag.findContainer();
    }

    private JavaFxComponentManager$() {
        MODULE$ = this;
        this.FontStyleNormal = "normal";
        this.FontStyleItalic = "italic";
        this.FontWeightBold = "bold";
    }
}

