/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguiraffe.gui.platform.javafx.builder.components.table;

import javafx.beans.value.ChangeListener;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import net.sf.jguiraffe.gui.builder.components.ComponentBuilderCallBack;
import net.sf.jguiraffe.gui.builder.components.ComponentBuilderData;
import net.sf.jguiraffe.gui.builder.components.Composite;
import net.sf.jguiraffe.gui.builder.components.tags.table.TableFormController;
import net.sf.jguiraffe.gui.forms.ComponentHandler;
import net.sf.jguiraffe.gui.layout.UnitSizeHandler;
import net.sf.jguiraffe.gui.platform.javafx.builder.components.table.JavaFxTableHandler;
import net.sf.jguiraffe.gui.platform.javafx.builder.components.table.StyleAwareRowFactory;
import net.sf.jguiraffe.gui.platform.javafx.builder.components.table.TableColumnRecalibrationResizePolicy;
import net.sf.jguiraffe.gui.platform.javafx.builder.components.table.TableColumnWidthChangeListener;
import net.sf.jguiraffe.gui.platform.javafx.builder.components.table.TableComponentFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001+\t\u0019B+\u00192mK\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ss*\u00111\u0001B\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003\u000b\u0019\t!bY8na>tWM\u001c;t\u0015\t9\u0001\"A\u0004ck&dG-\u001a:\u000b\u0005%Q\u0011A\u00026bm\u00064\u0007P\u0003\u0002\f\u0019\u0005A\u0001\u000f\\1uM>\u0014XN\u0003\u0002\u000e\u001d\u0005\u0019q-^5\u000b\u0005=\u0001\u0012!\u00036hk&\u0014\u0018M\u001a4f\u0015\t\t\"#\u0001\u0002tM*\t1#A\u0002oKR\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001aD\u0011\"\b\u0001\u0003\u0006\u0004%\tA\u0001\u0010\u0002!\r|W\u000e]8oK:$h)Y2u_JLX#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!\u0006+bE2,7i\\7q_:,g\u000e\u001e$bGR|'/\u001f\u0005\tI\u0001\u0011\t\u0011)A\u0005?\u0005\t2m\\7q_:,g\u000e\u001e$bGR|'/\u001f\u0011\t\r\u0019\u0002A\u0011\u0001\u0002(\u0003\u0019a\u0014N\\5u}Q\u0011\u0001&\u000b\t\u0003A\u0001AQ!H\u0013A\u0002}AQA\n\u0001\u0005\u0002-\"\u0012\u0001\u000b\u0005\u0006[\u0001!\tAL\u0001\u0013GJ,\u0017\r^3UC\ndW\rS1oI2,'\u000fF\u00030{!\u0003f\u000bE\u00021gUj\u0011!\r\u0006\u0003e1\tQAZ8s[NL!\u0001N\u0019\u0003!\r{W\u000e]8oK:$\b*\u00198eY\u0016\u0014\bC\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0011a\u0017M\\4\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u0007\u001f\nTWm\u0019;\t\u000byb\u0003\u0019A \u0002\u0015\r|g\u000e\u001e:pY2,'\u000f\u0005\u0002A\r6\t\u0011I\u0003\u0002\u0004\u0005*\u00111\tR\u0001\u0005i\u0006<7O\u0003\u0002\u0006\u000b*\u0011q\u0001D\u0005\u0003\u000f\u0006\u00131\u0003V1cY\u00164uN]7D_:$(o\u001c7mKJDQ!\u0013\u0017A\u0002)\u000b1b]5{K\"\u000bg\u000e\u001a7feB\u00111JT\u0007\u0002\u0019*\u0011Q\nD\u0001\u0007Y\u0006Lx.\u001e;\n\u0005=c%aD+oSR\u001c\u0016N_3IC:$G.\u001a:\t\u000bEc\u0003\u0019\u0001*\u0002\u0013\r|W\u000e]8tSR,\u0007CA*U\u001b\u0005!\u0015BA+E\u0005%\u0019u.\u001c9pg&$X\rC\u0003XY\u0001\u0007\u0001,A\u0006ck&dG-\u001a:ECR\f\u0007CA*Z\u0013\tQFI\u0001\u000bD_6\u0004xN\\3oi\n+\u0018\u000e\u001c3fe\u0012\u000bG/\u0019\u0005\u00069\u0002!I!X\u0001\u000eGJ,\u0017\r^3D_2,XN\\:\u0015\ty\u000b'-\u001c\t\u0003/}K!\u0001\u0019\r\u0003\tUs\u0017\u000e\u001e\u0005\u0006}m\u0003\ra\u0010\u0005\u0006Gn\u0003\r\u0001Z\u0001\ni\u0006\u0014G.\u001a,jK^\u00042!Z6\u0017\u001b\u00051'BA4i\u0003\u001d\u0019wN\u001c;s_2T!!\u001b6\u0002\u000bM\u001cWM\\3\u000b\u0003%I!\u0001\u001c4\u0003\u0013Q\u000b'\r\\3WS\u0016<\b\"\u00028\\\u0001\u0004y\u0017\u0001\u0004:fg&TX\rU8mS\u000eL\bC\u0001\u0011q\u0013\t\t(A\u0001\u0013UC\ndWmQ8mk6t'+Z2bY&\u0014'/\u0019;j_:\u0014Vm]5{KB{G.[2z\u0011\u0015\u0019\b\u0001\"\u0003u\u0003eIgn\u001d;bY2$\u0016M\u00197f/&$G\u000f\u001b'jgR,g.\u001a:\u0015\u0007y+h\u000fC\u0003?e\u0002\u0007q\bC\u0003de\u0002\u0007A\rC\u0003y\u0001\u0011%\u00110A\u000ej]&$\u0018.\u00197ju\u00164\u0015\u000e_3e\u0007>dW/\u001c8XS\u0012$\bn\u001d\u000b\u0006=j\\H0 \u0005\u0006}]\u0004\ra\u0010\u0005\u0006\u0013^\u0004\rA\u0013\u0005\u0006#^\u0004\rA\u0015\u0005\u0006/^\u0004\r\u0001\u0017")
public class TableHandlerFactory {
    private final TableComponentFactory componentFactory;

    public TableComponentFactory componentFactory() {
        return this.componentFactory;
    }

    public ComponentHandler<Object> createTableHandler(TableFormController controller, UnitSizeHandler sizeHandler, Composite composite, ComponentBuilderData builderData) {
        TableView tableView = new TableView();
        TableColumnRecalibrationResizePolicy resizePolicy = this.componentFactory().createColumnResizePolicy(controller.getColumnRecalibrator());
        StyleAwareRowFactory<Object> rowFactory = this.componentFactory().createRowFactory();
        this.createColumns(controller, (TableView<Object>)tableView, resizePolicy);
        tableView.setColumnResizePolicy((Callback)resizePolicy);
        tableView.setRowFactory(rowFactory);
        tableView.setEditable(controller.isTableEditable());
        this.installTableWidthListener(controller, (TableView<Object>)tableView);
        this.initializeFixedColumnWidths(controller, sizeHandler, composite, builderData);
        JavaFxTableHandler handler = new JavaFxTableHandler((TableView<Object>)tableView, controller.getDataModel(), rowFactory.styleProperty());
        handler.tableDataChanged();
        return handler;
    }

    private void createColumns(TableFormController controller, TableView<Object> tableView, TableColumnRecalibrationResizePolicy resizePolicy) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), controller.getColumnCount()).foreach((Function1)new Serializable(this, controller, tableView, resizePolicy){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TableHandlerFactory $outer;
            private final TableFormController controller$1;
            private final TableView tableView$1;
            private final TableColumnRecalibrationResizePolicy resizePolicy$1;

            public final TableColumnWidthChangeListener apply(int i) {
                TableColumn<Object, Object> column = this.$outer.componentFactory().columnFactory().createColumn(this.controller$1, i);
                this.tableView$1.getColumns().add(column);
                return this.resizePolicy$1.installWidthChangeListener(column);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.controller$1 = controller$1;
                this.tableView$1 = tableView$1;
                this.resizePolicy$1 = resizePolicy$1;
            }
        });
    }

    private void installTableWidthListener(TableFormController controller, TableView<Object> tableView) {
        ChangeListener<Number> widthListener = this.componentFactory().createTableWidthListener(controller.getColumnWidthCalculator(), tableView);
        this.componentFactory().tableWidthProperty(tableView).addListener(widthListener);
    }

    private void initializeFixedColumnWidths(TableFormController controller, UnitSizeHandler sizeHandler, Composite composite, ComponentBuilderData builderData) {
        builderData.addCallBack(new ComponentBuilderCallBack(this, controller, sizeHandler, composite){
            private final TableFormController controller$2;
            private final UnitSizeHandler sizeHandler$1;
            private final Composite composite$1;

            public void callBack(ComponentBuilderData builderData, Object params) {
                this.controller$2.calculateFixedColumnWidths(this.sizeHandler$1, this.composite$1.getContainer());
            }
            {
                this.controller$2 = controller$2;
                this.sizeHandler$1 = sizeHandler$1;
                this.composite$1 = composite$1;
            }
        }, null);
    }

    public TableHandlerFactory(TableComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public TableHandlerFactory() {
        this(new TableComponentFactory());
    }
}

