/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.auth;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.collection.MapWithSets;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.auth.AlreadyAuthenticatedException;
import net.sf.jstuff.integration.auth.AuthListener;
import net.sf.jstuff.integration.auth.AuthService;
import net.sf.jstuff.integration.auth.Authentication;
import net.sf.jstuff.integration.auth.AuthenticationFailedException;
import net.sf.jstuff.integration.auth.AuthenticationHolder;
import net.sf.jstuff.integration.auth.Authenticator;
import net.sf.jstuff.integration.auth.DefaultAuthentication;
import net.sf.jstuff.integration.auth.PermissionDeniedException;
import net.sf.jstuff.integration.auth.UnknownApplicationRoleException;
import net.sf.jstuff.integration.userregistry.GroupDetailsService;
import net.sf.jstuff.integration.userregistry.UserDetails;
import net.sf.jstuff.integration.userregistry.UserDetailsService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.util.PatternMatchUtils;

public class DefaultAuthService
implements AuthService {
    private static final Logger LOG = Logger.create();
    protected Set<String> applicationRoles = (Set)NullAnalysisHelper.lazyNonNull();
    protected Authenticator authenticator = (Authenticator)NullAnalysisHelper.lazyNonNull();
    protected GroupDetailsService groupDetailsService = (GroupDetailsService)NullAnalysisHelper.lazyNonNull();
    protected MapWithSets<String, String> groupIdToApplicationRoleMappings = (MapWithSets)NullAnalysisHelper.lazyNonNull();
    protected @Nullable AuthListener listener;
    protected MapWithSets<String, String> uriPatternsToApplicationRoleMappings = (MapWithSets)NullAnalysisHelper.lazyNonNull();
    protected UserDetailsService userDetailsService = (UserDetailsService)NullAnalysisHelper.lazyNonNull();

    public DefaultAuthService() {
        LOG.infoNew((Object)this);
    }

    @Override
    public void assertAuthenticated() throws PermissionDeniedException {
        if (!this.isAuthenticated()) {
            throw new PermissionDeniedException("You are not authorized to perform that operation. You need to authenticate first.");
        }
    }

    @Override
    public void assertIdentity(String userId) throws PermissionDeniedException {
        if (!this.isIdentity(userId)) {
            throw new PermissionDeniedException("You are not authorized to perform that operation. Identity mismatch.");
        }
    }

    @Override
    public void assertRole(String applicationRole) throws PermissionDeniedException {
        if (!this.hasRole(applicationRole)) {
            throw new PermissionDeniedException("You are not authorized to perform that operation.");
        }
    }

    @Override
    public void assertURIAccess(String uri) throws PermissionDeniedException {
        for (Map.Entry entry : this.uriPatternsToApplicationRoleMappings.entrySet()) {
            String uriPattern = (String)entry.getKey();
            if (PatternMatchUtils.simpleMatch((String)uriPattern, (String)uri)) {
                LOG.trace("%s matches %s", (Object)uri, (Object)uriPattern);
                Collection roles = (Collection)entry.getValue();
                if (roles.isEmpty()) continue;
                boolean hasAnyRequiredRole = false;
                for (String requiredRole : roles) {
                    if (!this.hasRole(requiredRole)) continue;
                    hasAnyRequiredRole = true;
                    break;
                }
                if (hasAnyRequiredRole) continue;
                throw new PermissionDeniedException("You are not authorized to perform that operation.");
            }
            LOG.trace("%s does NOT match %s", (Object)uri, (Object)uriPattern);
        }
    }

    @Override
    public Authentication getAuthentication() {
        return AuthenticationHolder.getAuthentication();
    }

    @Override
    public Set<String> getGrantedRoles() {
        Authentication auth = AuthenticationHolder.getAuthentication();
        if (!auth.isAuthenticated()) {
            LOG.trace("User is not authenticated.");
            return Collections.emptySet();
        }
        return this.getGrantedRoles(((UserDetails)NullAnalysisHelper.asNonNull((Object)auth.getUserDetails())).getDistinguishedName());
    }

    protected Set<String> getGrantedRoles(@Nullable String userDN) {
        if (userDN == null || Strings.isBlank((CharSequence)userDN)) {
            return Collections.emptySet();
        }
        Set<String> groupIds = this.groupDetailsService.getGroupIdsByUserDN(userDN);
        HashSet<String> roles = new HashSet<String>();
        for (String groupId : groupIds) {
            Collection coll = (Collection)this.groupIdToApplicationRoleMappings.get((Object)groupId);
            if (coll == null) continue;
            roles.addAll(coll);
        }
        return roles;
    }

    @Override
    public Set<String> getGroupIds() {
        Authentication auth = AuthenticationHolder.getAuthentication();
        if (!auth.isAuthenticated()) {
            LOG.trace("User is not authenticated.");
            return Collections.emptySet();
        }
        return this.groupDetailsService.getGroupIdsByUserDN((String)NullAnalysisHelper.asNonNull((Object)((UserDetails)NullAnalysisHelper.asNonNull((Object)auth.getUserDetails())).getDistinguishedName()));
    }

    @Override
    public boolean hasRole(String applicationRole) {
        return this.getGrantedRoles().contains(applicationRole);
    }

    @Override
    public boolean isAuthenticated() {
        return AuthenticationHolder.getAuthentication().isAuthenticated();
    }

    @Override
    public boolean isIdentity(String userId) throws PermissionDeniedException {
        Authentication auth = AuthenticationHolder.getAuthentication();
        return auth.isAuthenticated() && ((UserDetails)NullAnalysisHelper.asNonNull((Object)auth.getUserDetails())).getUserId().equals(userId);
    }

    @Override
    public void login(String logonName, String password) throws AuthenticationFailedException, AlreadyAuthenticatedException {
        if (this.isAuthenticated()) {
            throw new AlreadyAuthenticatedException("An authentication for the active session already exists.");
        }
        if (this.isAuthenticated()) {
            this.logout();
        }
        if (!this.authenticator.authenticate(logonName, password)) {
            throw new AuthenticationFailedException("Incorrect username or password.");
        }
        DefaultAuthentication auth = new DefaultAuthentication(this.userDetailsService.getUserDetailsByLogonName(logonName), password);
        AuthenticationHolder.setAuthentication(auth);
        if (this.listener != null) {
            this.listener.afterLogin(auth);
        }
    }

    @Override
    public void logout() {
        UserDetails userDetails;
        Authentication auth = AuthenticationHolder.getAuthentication();
        auth.invalidate();
        AuthListener listener = this.listener;
        if (listener != null && (userDetails = auth.getUserDetails()) != null) {
            listener.afterLogout(userDetails);
        }
    }

    @Inject
    public synchronized void setApplicationRoles(String ... applicationRoles) {
        this.applicationRoles = new HashSet<String>();
        String[] stringArray = applicationRoles;
        int n = applicationRoles.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            LOG.trace("Registering application role: %s", (Object)element);
            this.applicationRoles.add(element);
            ++n2;
        }
    }

    @Inject
    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Inject
    public void setGroupDetailsService(GroupDetailsService groupDetailsService) {
        this.groupDetailsService = groupDetailsService;
    }

    @Inject
    public synchronized void setGroupIdToApplicationRoleMappings(Map<String, String> mappings) throws UnknownApplicationRoleException {
        this.groupIdToApplicationRoleMappings = new MapWithSets();
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            String role;
            String group = mapping.getKey().trim();
            if (group.length() <= 0 || (role = mapping.getValue().trim()).length() <= 0) continue;
            LOG.trace("Registering groupId -> application role mapping: %s => %s", (Object)group, (Object)role);
            if (!this.applicationRoles.contains(role)) {
                throw new UnknownApplicationRoleException("Application role is unknown: " + role);
            }
            this.groupIdToApplicationRoleMappings.add((Object)group, (Object)role);
        }
    }

    @Inject
    public synchronized void setGroupIdToApplicationRoleMappingsViaStringArray(@NonNull String[] mappings) throws UnknownApplicationRoleException {
        this.groupIdToApplicationRoleMappings = new MapWithSets();
        String[] stringArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] pair = Strings.split((String)element, (char)'=');
            pair[0] = pair[0].trim();
            pair[1] = pair[1].trim();
            if (pair[0].length() != 0 && pair[1].length() != 0) {
                LOG.trace("Registering groupId -> application role mapping: %s => %s", (Object)pair[0], (Object)pair[1]);
                if (!this.applicationRoles.contains(pair[1])) {
                    throw new UnknownApplicationRoleException("Application role is unknown: " + pair[1]);
                }
                this.groupIdToApplicationRoleMappings.add((Object)pair[0], (Object)pair[1]);
            }
            ++n2;
        }
    }

    @Override
    public void setListener(AuthListener listener) {
        this.listener = listener;
    }

    @Inject
    public synchronized void setUriPatternsToApplicationRoleMappings(@NonNull String[] mappings) throws UnknownApplicationRoleException {
        this.uriPatternsToApplicationRoleMappings = new MapWithSets();
        String[] stringArray = mappings;
        int n = mappings.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            String[] pair = Strings.split((String)element, (char)'=');
            pair[0] = pair[0].trim();
            pair[1] = pair[1].trim();
            if (pair[0].length() != 0 && pair[1].length() != 0) {
                LOG.trace("Registering URI pattern -> application role mapping: %s => %s", (Object)pair[0], (Object)pair[1]);
                if (!this.applicationRoles.contains(pair[1])) {
                    throw new UnknownApplicationRoleException("Application role is unknown: " + pair[1]);
                }
                this.uriPatternsToApplicationRoleMappings.add((Object)pair[0], (Object)pair[1]);
            }
            ++n2;
        }
    }

    @Inject
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

