/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.auth;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.jstuff.integration.auth.Authentication;
import net.sf.jstuff.integration.userregistry.DefaultUserDetails;
import net.sf.jstuff.integration.userregistry.UserDetails;
import org.eclipse.jdt.annotation.Nullable;

class DefaultAuthentication
implements Authentication {
    private static final long serialVersionUID = 1L;
    public static final Authentication UNBOUND = new DefaultAuthentication(new DefaultUserDetails("anonymous", "anonymous", null, null, null), null);
    private @Nullable String password;
    private final Map<String, Serializable> properties = new HashMap<String, Serializable>(2);
    private @Nullable UserDetails userDetails;

    DefaultAuthentication(@Nullable UserDetails userDetails, @Nullable String password) {
        this.userDetails = userDetails;
        this.password = password;
    }

    @Override
    public @Nullable String getPassword() {
        return this.password;
    }

    @Override
    public @Nullable Serializable getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public @Nullable UserDetails getUserDetails() {
        return this.userDetails;
    }

    @Override
    public void invalidate() {
        this.userDetails = UNBOUND.getUserDetails();
        this.properties.clear();
        this.password = null;
    }

    @Override
    public boolean isAuthenticated() {
        return this.userDetails != null && this.userDetails.getDistinguishedName() != null;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public void setProperty(String name, Serializable value) {
        this.properties.put(name, value);
    }
}

