/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.auth;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.auth.AuthService;
import net.sf.jstuff.integration.auth.Authentication;
import net.sf.jstuff.integration.auth.AuthenticationHolder;
import net.sf.jstuff.integration.auth.DefaultAuthentication;
import net.sf.jstuff.integration.auth.PermissionDeniedException;
import net.sf.jstuff.integration.userregistry.UserDetailsService;

public class SecurityFilter
implements Filter {
    private static final Logger LOG = Logger.create();
    private static final String SESSION_AUTHENTICATION_ATTRIBUTE = Authentication.class.getName();
    public static final ThreadLocal<HttpServletRequest> HTTP_SERVLET_REQUEST_HOLDER = new ThreadLocal();
    private AuthService authService = (AuthService)NullAnalysisHelper.lazyNonNull();
    private UserDetailsService userDetailsService = (UserDetailsService)NullAnalysisHelper.lazyNonNull();

    public SecurityFilter() {
        LOG.infoNew((Object)this);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HTTP_SERVLET_REQUEST_HOLDER.set(req);
        HttpSession sess = req.getSession();
        LOG.debug("URI = %s", (Object)req.getRequestURI());
        boolean wasLoggedInBeforeChain = false;
        Authentication auth = (Authentication)sess.getAttribute(SESSION_AUTHENTICATION_ATTRIBUTE);
        try {
            try {
                if (auth == null) {
                    String remoteUser = req.getRemoteUser();
                    if (remoteUser != null) {
                        auth = new DefaultAuthentication(this.userDetailsService.getUserDetailsByLogonName(remoteUser), (String)sess.getAttribute("j_password"));
                        sess.removeAttribute("j_password");
                        sess.setAttribute(SESSION_AUTHENTICATION_ATTRIBUTE, (Object)auth);
                    } else {
                        auth = DefaultAuthentication.UNBOUND;
                    }
                }
                AuthenticationHolder.setAuthentication(auth);
                wasLoggedInBeforeChain = auth.isAuthenticated();
                this.authService.assertURIAccess(req.getRequestURI().substring(req.getContextPath().length()));
                chain.doFilter(request, response);
            }
            catch (PermissionDeniedException ex) {
                if (response.isCommitted()) {
                    throw ex;
                }
                ((HttpServletResponse)response).sendError(403, ex.getMessage());
                auth = AuthenticationHolder.getAuthentication();
                if (wasLoggedInBeforeChain && !auth.isAuthenticated()) {
                    sess.invalidate();
                } else if (!wasLoggedInBeforeChain && auth.isAuthenticated()) {
                    sess.setAttribute(SESSION_AUTHENTICATION_ATTRIBUTE, (Object)AuthenticationHolder.getAuthentication());
                }
                AuthenticationHolder.setAuthentication(DefaultAuthentication.UNBOUND);
                HTTP_SERVLET_REQUEST_HOLDER.remove();
            }
        }
        finally {
            auth = AuthenticationHolder.getAuthentication();
            if (wasLoggedInBeforeChain && !auth.isAuthenticated()) {
                sess.invalidate();
            } else if (!wasLoggedInBeforeChain && auth.isAuthenticated()) {
                sess.setAttribute(SESSION_AUTHENTICATION_ATTRIBUTE, (Object)AuthenticationHolder.getAuthentication());
            }
            AuthenticationHolder.setAuthentication(DefaultAuthentication.UNBOUND);
            HTTP_SERVLET_REQUEST_HOLDER.remove();
        }
    }

    public void init(FilterConfig cfg) throws ServletException {
    }

    @Inject
    public void setAuthService(AuthService authService) {
        this.authService = authService;
    }

    @Inject
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }
}

