/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.compression;

import com.aayushatharva.brotli4j.Brotli4jLoader;
import com.aayushatharva.brotli4j.decoder.BrotliInputStream;
import com.aayushatharva.brotli4j.decoder.Decoder;
import com.aayushatharva.brotli4j.decoder.DecoderJNI;
import com.aayushatharva.brotli4j.decoder.DirectDecompress;
import com.aayushatharva.brotli4j.encoder.BrotliOutputStream;
import com.aayushatharva.brotli4j.encoder.Encoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.compression.AbstractCompression;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.Assert;

public class BrotliCompression
extends AbstractCompression {
    public static final int LEVEL_SMALL_AS_DEFLATE_4 = 2;
    public static final int LEVEL_SMALL_AS_DEFLATE_6 = 4;
    public static final int LEVEL_SMALL_AS_DEFLATE_9 = 4;
    public static final BrotliCompression INSTANCE = new BrotliCompression(2);
    private final int compressionLevel;
    private final Encoder.Parameters encoderParams;

    static {
        Assert.isTrue((boolean)Brotli4jLoader.isAvailable(), (String)"Failed to load Brotli native library!");
    }

    public BrotliCompression(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        this.encoderParams = new Encoder.Parameters();
        this.encoderParams.setQuality(compressionLevel);
    }

    public byte[] compress(byte[] uncompressed) throws IOException {
        Args.notNull((String)"uncompressed", (Object)uncompressed);
        return Encoder.compress((byte[])uncompressed, (Encoder.Parameters)this.encoderParams);
    }

    public OutputStream createCompressingOutputStream(OutputStream output) throws IOException {
        Args.notNull((String)"output", (Object)output);
        return new BrotliOutputStream(output, this.encoderParams);
    }

    public InputStream createDecompressingInputStream(InputStream compressed) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        return new BrotliInputStream(compressed);
    }

    public byte[] decompress(byte[] compressed) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        DirectDecompress result = Decoder.decompress((byte[])compressed);
        if (result.getResultStatus() != DecoderJNI.Status.DONE) {
            throw new IOException("Decompression via Brotli native library failed with: " + result.getResultStatus());
        }
        return result.getDecompressedData();
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public String toString() {
        return Strings.toString((Object)((Object)this), (Object[])new Object[]{"compressionLevel", this.compressionLevel});
    }
}

