/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.compression;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.xxhash.XXHashFactory;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.collection.ArrayUtils;
import net.sf.jstuff.core.compression.AbstractCompression;
import net.sf.jstuff.core.io.IOUtils;
import net.sf.jstuff.core.io.stream.DelegatingOutputStream;
import net.sf.jstuff.core.validation.Args;

public class LZ4BlockCompression
extends AbstractCompression {
    public static final LZ4BlockCompression INSTANCE = new LZ4BlockCompression();
    private static final int DEFAULT_BLOCK_SIZE = 65536;
    private static final LZ4Compressor COMP = LZ4Factory.fastestInstance().fastCompressor();
    private static final LZ4FastDecompressor DECOMP = LZ4Factory.fastestInstance().fastDecompressor();
    private static final ThreadLocal<Checksum> CHECKSUM = ThreadLocal.withInitial(() -> XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum());

    protected LZ4BlockCompression() {
    }

    public void compress(byte[] uncompressed, OutputStream output) throws IOException {
        Args.notNull((String)"uncompressed", (Object)uncompressed);
        Args.notNull((String)"output", (Object)output);
        int blockSize = uncompressed.length >= 65536 ? 65536 : (uncompressed.length < 65 ? 64 : uncompressed.length);
        Throwable throwable = null;
        Object var5_6 = null;
        try (LZ4BlockOutputStream compOS = new LZ4BlockOutputStream((OutputStream)this.toCloseIgnoring(output), blockSize, COMP, CHECKSUM.get(), false);){
            compOS.write(uncompressed);
            compOS.finish();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void compress(InputStream uncompressed, OutputStream output) throws IOException {
        Args.notNull((String)"uncompressed", (Object)uncompressed);
        Args.notNull((String)"output", (Object)output);
        output = new DelegatingOutputStream(output, true);
        Throwable throwable = null;
        Object var4_5 = null;
        try (LZ4BlockOutputStream compOS = new LZ4BlockOutputStream((OutputStream)this.toCloseIgnoring(output), 65536, COMP, CHECKSUM.get(), false);){
            IOUtils.copyLarge((InputStream)uncompressed, (OutputStream)compOS);
            compOS.finish();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public OutputStream createCompressingOutputStream(OutputStream output) throws IOException {
        Args.notNull((String)"output", (Object)output);
        return new LZ4BlockOutputStream(output, 65536, COMP);
    }

    public InputStream createDecompressingInputStream(InputStream compressed) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        return new LZ4BlockInputStream(compressed, DECOMP);
    }

    public void decompress(InputStream compressed, OutputStream output) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        Args.notNull((String)"output", (Object)output);
        Throwable throwable = null;
        Object var4_5 = null;
        try (LZ4BlockInputStream compIS = new LZ4BlockInputStream((InputStream)this.toCloseIgnoring(compressed), DECOMP, CHECKSUM.get());){
            IOUtils.copyLarge((InputStream)compIS, (OutputStream)output);
            output.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        return Strings.toString((Object)((Object)this), (Object[])ArrayUtils.EMPTY_OBJECT_ARRAY);
    }
}

