/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.compression;

import com.ning.compress.lzf.LZFDecoder;
import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.LZFInputStream;
import com.ning.compress.lzf.LZFOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.collection.ArrayUtils;
import net.sf.jstuff.core.compression.AbstractCompression;
import net.sf.jstuff.core.validation.Args;

public class LZFCompression
extends AbstractCompression {
    public static final LZFCompression INSTANCE = new LZFCompression();

    protected LZFCompression() {
    }

    public byte[] compress(byte[] uncompressed) throws IOException {
        Args.notNull((String)"uncompressed", (Object)uncompressed);
        return LZFEncoder.encode((byte[])uncompressed);
    }

    public OutputStream createCompressingOutputStream(OutputStream output) throws IOException {
        Args.notNull((String)"output", (Object)output);
        return new LZFOutputStream(output);
    }

    public InputStream createDecompressingInputStream(InputStream compressed) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        return new LZFInputStream(compressed);
    }

    public byte[] decompress(byte[] compressed) throws IOException {
        Args.notNull((String)"compressed", (Object)compressed);
        return LZFDecoder.decode((byte[])compressed);
    }

    public String toString() {
        return Strings.toString((Object)((Object)this), (Object[])ArrayUtils.EMPTY_OBJECT_ARRAY);
    }
}

