/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.Nullable;

public final class JsonNode
extends ObjectNode {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper(new JsonFactory());
    private static final long serialVersionUID = 1L;

    public static JsonNode create() {
        return new JsonNode(OBJECT_MAPPER.getNodeFactory());
    }

    private JsonNode(JsonNodeFactory nc) {
        super(nc);
    }

    public JsonNode compute(Consumer<JsonNode> consumer) {
        consumer.accept(this);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable BigDecimal v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable BigInteger v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, boolean v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable Boolean v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, byte @Nullable [] v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable com.fasterxml.jackson.databind.JsonNode value) {
        this.set(fieldName, value);
        return this;
    }

    public JsonNode put(String fieldName, double v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable Double v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, float v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable Float v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, int v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable Integer v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, long v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable Long v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable Object obj) {
        super.set(fieldName, obj == null ? null : OBJECT_MAPPER.valueToTree(obj));
        return this;
    }

    public JsonNode put(String fieldName, short v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable Short v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode put(String fieldName, @Nullable String v) {
        super.put(fieldName, v);
        return this;
    }

    public JsonNode putNull(String fieldName) {
        super.putNull(fieldName);
        return this;
    }

    public JsonNode putPOJO(String fieldName, @Nullable Object pojo) {
        super.putPOJO(fieldName, pojo);
        return this;
    }

    public JsonNode putRawValue(String fieldName, @Nullable RawValue raw) {
        super.putRawValue(fieldName, raw);
        return this;
    }

    public JsonNode remove(Collection<String> fieldNames) {
        super.remove(fieldNames);
        return this;
    }

    public @Nullable com.fasterxml.jackson.databind.JsonNode remove(@Nullable String fieldName) {
        com.fasterxml.jackson.databind.JsonNode removedValue = super.remove(fieldName);
        return removedValue;
    }

    public JsonNode removeAll() {
        super.removeAll();
        return this;
    }

    public com.fasterxml.jackson.databind.JsonNode replace(String fieldName, @Nullable com.fasterxml.jackson.databind.JsonNode value) {
        com.fasterxml.jackson.databind.JsonNode replacedValue = super.replace(fieldName, value);
        return replacedValue;
    }

    public JsonNode retain(Collection<String> fieldNames) {
        super.retain(fieldNames);
        return this;
    }

    public JsonNode retain(String ... fieldNames) {
        super.retain(fieldNames);
        return this;
    }

    public JsonNode set(String fieldName, @Nullable com.fasterxml.jackson.databind.JsonNode value) {
        super.set(fieldName, value);
        return this;
    }

    public <T extends com.fasterxml.jackson.databind.JsonNode> T setAll(Map<String, ? extends com.fasterxml.jackson.databind.JsonNode> properties) {
        super.setAll(properties);
        return (T)((Object)this);
    }

    public JsonNode setAll(ObjectNode other) {
        super.setAll(other);
        return this;
    }

    public <T extends com.fasterxml.jackson.databind.JsonNode> T without(Collection<String> fieldNames) {
        super.without(fieldNames);
        return (T)((Object)this);
    }

    public JsonNode without(String fieldName) {
        super.without(fieldName);
        return this;
    }
}

