/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jstuff.core.collection.CollectionUtils;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.reflection.Methods;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.spring.SpringBeanParanamer;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.support.RemoteExporter;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.util.NestedServletException;

public class SMDServiceExporter
extends RemoteExporter
implements HttpRequestHandler,
InitializingBean {
    private static final Logger LOG = Logger.create();
    private static final ObjectMapper JSON = new ObjectMapper();
    private static final ObjectWriter JSON_PRETTY_WRITER = JSON.writerWithDefaultPrettyPrinter();
    private Map<String, Method> exportedMethodsByName = Collections.emptyMap();
    private String smdTemplate = "";

    public static Map<String, Method> buildExportedMethodsByName(Class<?> serviceInterface) {
        TreeMap<String, Method> methodsByMethodName = new TreeMap<String, Method>();
        HashMap<String, Class<?>[]> parameterTypesByMethodName = new HashMap<String, Class<?>[]>();
        Class<?> clazz = serviceInterface;
        while (clazz != null) {
            Method[] publicMethods;
            Method[] methodArray = publicMethods = serviceInterface.getMethods();
            int n = publicMethods.length;
            int n2 = 0;
            while (n2 < n) {
                Method method = methodArray[n2];
                String name = method.getName();
                if (methodsByMethodName.containsKey(name)) {
                    Object[] registeredMethodParamTypes;
                    Object[] currentMethodParamTypes = method.getParameterTypes();
                    if (!Arrays.equals(currentMethodParamTypes, registeredMethodParamTypes = (Class[])parameterTypesByMethodName.get(name))) {
                        throw new IllegalStateException("Method overloading is not supported");
                    }
                } else {
                    methodsByMethodName.put(name, method);
                    parameterTypesByMethodName.put(name, method.getParameterTypes());
                }
                ++n2;
            }
            clazz = clazz.getSuperclass();
        }
        return methodsByMethodName;
    }

    public static String buildSMDTemplate(Class<?> serviceInterface, Object service, Map<String, Method> exportedMethodsByName, boolean pretty) throws JsonProcessingException {
        LinkedHashMap methodDescriptions = new LinkedHashMap();
        for (Method method : exportedMethodsByName.values()) {
            LinkedHashMap methodDescriptor = new LinkedHashMap();
            if (method.getParameterTypes().length > 0) {
                String[] names = SpringBeanParanamer.getParameterNames(method, service);
                ArrayList parameters = CollectionUtils.newArrayList();
                int j = 0;
                while (j < method.getParameterTypes().length) {
                    JsonSchema parameterDescriptor = JSON.generateJsonSchema(method.getParameterTypes()[j]);
                    parameterDescriptor.getSchemaNode().put("name", names[0]);
                    parameterDescriptor.getSchemaNode().put("java-type", method.getParameterTypes()[j].getName());
                    parameters.add(parameterDescriptor);
                    ++j;
                }
                methodDescriptor.put("parameters", parameters);
            }
            if (!Methods.isReturningVoid((Method)method)) {
                JsonSchema returnTypeDescriptor = JSON.generateJsonSchema(method.getReturnType());
                returnTypeDescriptor.getSchemaNode().put("java-type", method.getReturnType().getName());
                methodDescriptor.put("returns", returnTypeDescriptor);
            }
            methodDescriptions.put(method.getName(), methodDescriptor);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
        result.put("SMDVersion", "2.0");
        result.put("id", serviceInterface.getClass().getName());
        result.put("description", "");
        result.put("transport", "POST");
        result.put("envelope", "JSON-RPC-1.0");
        result.put("additionalParameters", false);
        result.put("target", "THE_SERVICE_URL");
        result.put("services", methodDescriptions);
        LOG.exit(result);
        if (pretty) {
            return JSON_PRETTY_WRITER.writeValueAsString(result);
        }
        return JSON.writeValueAsString(result);
    }

    public SMDServiceExporter() {
        LOG.infoNew((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        Class srvIFace = (Class)NullAnalysisHelper.asNonNullUnsafe((Object)this.getServiceInterface());
        this.exportedMethodsByName = SMDServiceExporter.buildExportedMethodsByName(srvIFace);
        this.smdTemplate = SMDServiceExporter.buildSMDTemplate(srvIFace, NullAnalysisHelper.asNonNullUnsafe((Object)this.getService()), this.exportedMethodsByName, false);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("POST".equals(request.getMethod())) {
            this.invokeMethod(request, response);
        } else if ("GET".equals(request.getMethod())) {
            String smd = this.smdTemplate.replaceFirst("THE_SERVICE_URL", request.getRequestURL().toString());
            response.getWriter().write(smd);
        }
    }

    private void invokeMethod(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        JsonNode requestObject = JSON.readTree((Reader)request.getReader());
        String methodName = requestObject.get("method").asText();
        Method method = this.exportedMethodsByName.get(methodName);
        if (method == null) {
            throw new ServletException("Method " + methodName + " not found");
        }
        try {
            JsonNode paramsNode = requestObject.get("params");
            Object[] methodArguments = new Object[paramsNode.size()];
            Class<?>[] methodParameterTypes = method.getParameterTypes();
            int i = 0;
            int l = paramsNode.size();
            while (i < l) {
                JsonNode paramNode = paramsNode.get(i);
                if (paramNode != null) {
                    methodArguments[i] = JSON.treeToValue((TreeNode)paramNode, methodParameterTypes[i]);
                }
                ++i;
            }
            Object methodReturnValue = method.invoke(this.getProxyForService(), methodArguments);
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(2);
            result.put("id", requestObject.get("id").asText());
            result.put("result", methodReturnValue);
            JSON.writeValue((Writer)response.getWriter(), result);
            LOG.exit(result);
        }
        catch (Exception ex) {
            throw new NestedServletException("Invoking method " + methodName + " failed", (Throwable)ex);
        }
    }
}

