/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.mail;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import org.eclipse.jdt.annotation.NonNull;

public abstract class MailUtils {
    public static void sendMail(@NonNull Mail mail, final @NonNull MailServer mailServer) throws AddressException, MessagingException {
        String item;
        int n;
        int n2;
        String[] stringArray;
        Session session;
        Args.notNull((String)"mail", (Object)mail);
        Args.notNull((String)"mailServer", (Object)mailServer);
        Args.notNull((String)"mailServer.smtpHostname", (Object)mailServer.smtpHostname);
        Properties props = new Properties();
        props.put("mail.smtp.host", NullAnalysisHelper.asNonNullUnsafe((Object)mailServer.smtpHostname));
        props.put("mail.smtp.dsn.notify", "FAILURE");
        props.put("mail.smtp.port", Integer.toString(mailServer.smtpPort));
        if (Strings.isEmpty((CharSequence)mailServer.smtpUsername)) {
            session = Session.getDefaultInstance((Properties)props, null);
        } else {
            props.put("mail.smtp.auth", "true");
            Authenticator auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mailServer.smtpUsername, Strings.emptyIfNull((Object)mailServer.smtpPassword));
                }
            };
            session = Session.getInstance((Properties)props, (Authenticator)auth);
        }
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(mail.emailFrom));
        msg.setSubject(mail.subject);
        if (mail.emailTo != null) {
            stringArray = mail.emailTo;
            n2 = mail.emailTo.length;
            n = 0;
            while (n < n2) {
                item = stringArray[n];
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(item));
                ++n;
            }
        }
        if (mail.emailCC != null) {
            stringArray = mail.emailCC;
            n2 = mail.emailCC.length;
            n = 0;
            while (n < n2) {
                item = stringArray[n];
                msg.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(item));
                ++n;
            }
        }
        if (mail.emailBCC != null) {
            stringArray = mail.emailBCC;
            n2 = mail.emailBCC.length;
            n = 0;
            while (n < n2) {
                item = stringArray[n];
                msg.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(item));
                ++n;
            }
        }
        if (mail.emailReturnReceiptTo != null) {
            msg.setHeader("Return-Receipt-To", mail.emailReturnReceiptTo);
        }
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart text = new MimeBodyPart();
        text.setDisposition("inline");
        text.setContent((Object)mail.message, mail.isPlainTextMessage ? "text/plain" : "text/html");
        mp.addBodyPart((BodyPart)text);
        if (mail.attachments != null) {
            FileTypeMap fileTypeMap = new FileTypeMap(){

                public String getContentType(File file) {
                    return this.getContentType(file.getName());
                }

                public String getContentType(String fileName) {
                    if (fileName.toLowerCase().endsWith(".gif")) {
                        return "image/gif";
                    }
                    if (fileName.toLowerCase().endsWith(".png")) {
                        return "image/png";
                    }
                    if (fileName.toLowerCase().endsWith(".pdf")) {
                        return "application/pdf";
                    }
                    return "application/octet-stream";
                }
            };
            File[] fileArray = mail.attachments;
            int n3 = mail.attachments.length;
            int n4 = 0;
            while (n4 < n3) {
                File file = fileArray[n4];
                MimeBodyPart filePart = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(file);
                fds.setFileTypeMap(fileTypeMap);
                DataHandler dh = new DataHandler((DataSource)fds);
                filePart.setFileName(file.getName());
                filePart.setDisposition("attachment");
                filePart.setDescription("Attached file: " + file.getName());
                filePart.setDataHandler(dh);
                mp.addBodyPart((BodyPart)filePart);
                ++n4;
            }
        }
        msg.setContent((Multipart)mp);
        msg.setSentDate(new Date());
        msg.saveChanges();
        Transport.send((Message)msg);
    }

    public static class Mail
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public File[] attachments;
        public String[] emailBCC;
        public String[] emailCC;
        public String emailFrom;
        public String emailReturnReceiptTo;
        public String[] emailTo;
        public boolean isPlainTextMessage = true;
        public String message;
        public String subject;
    }

    public static class MailServer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String smtpHostname;
        public String smtpPassword;
        public int smtpPort = 25;
        public String smtpUsername;
    }
}

