/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.jstuff.core.GCTracker;
import net.sf.jstuff.core.collection.WeakIdentityHashSet;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.types.Identifiable;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import org.eclipse.jdt.annotation.Nullable;

public final class HashCodeManager {
    private static final GCTracker<String> GC_TRACKER = new GCTracker<String>(100){
        private final Logger log = Logger.create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onGCEvent(String trackingId) {
            block12: {
                try {
                    HashCodeAssignment ida = (HashCodeAssignment)HASHCODE_ASSIGNMENT_BY_TRACKING_ID.get(trackingId);
                    if (ida == null) {
                        return;
                    }
                    WeakIdentityHashSet<Identifiable<?>> weakIdentityHashSet = ida.identifiables;
                    synchronized (weakIdentityHashSet) {
                        if (ida.identifiables.isEmpty()) {
                            HASHCODE_ASSIGNMENT_BY_TRACKING_ID.remove(trackingId, ida);
                        }
                    }
                    if (ida.id == null) {
                        return;
                    }
                    HashCodeAssignment ida2 = (HashCodeAssignment)HASHCODE_ASSIGNMENT_BY_ID.get(ida.id);
                    if (ida2 == null) break block12;
                    WeakIdentityHashSet<Identifiable<?>> weakIdentityHashSet2 = ida2.identifiables;
                    synchronized (weakIdentityHashSet2) {
                        if (ida2.identifiables.isEmpty()) {
                            HASHCODE_ASSIGNMENT_BY_ID.remove(ida2.id, ida2);
                        }
                    }
                }
                catch (Exception ex) {
                    this.log.error((Throwable)ex);
                }
            }
        }
    };
    private static final ConcurrentMap<FQId, HashCodeAssignment> HASHCODE_ASSIGNMENT_BY_ID = new ConcurrentHashMap<FQId, HashCodeAssignment>();
    private static final ConcurrentMap<String, HashCodeAssignment> HASHCODE_ASSIGNMENT_BY_TRACKING_ID = new ConcurrentHashMap<String, HashCodeAssignment>();
    private static final AtomicLong LOCAL_ID_GENERATOR = new AtomicLong(0L);
    private static final String LOCAL_JVM_ID = UUID.randomUUID().toString();

    public static int getManagedIdsCount() {
        return HASHCODE_ASSIGNMENT_BY_ID.size();
    }

    public static int getManagedTrackingIdsCount() {
        return HASHCODE_ASSIGNMENT_BY_TRACKING_ID.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashCodeAssignment getOrRegisterHashCodeAssignmentByTrackingId(Identifiable<?> entity, String trackingId) {
        HashCodeAssignment newHca = new HashCodeAssignment(trackingId.hashCode());
        HashCodeAssignment hca = HASHCODE_ASSIGNMENT_BY_TRACKING_ID.putIfAbsent(trackingId, newHca);
        if (hca == null) {
            hca = newHca;
        }
        WeakIdentityHashSet<Identifiable<?>> weakIdentityHashSet = hca.identifiables;
        synchronized (weakIdentityHashSet) {
            hca.identifiables.add(entity);
        }
        return hca;
    }

    public static int hashCodeFor(Identifiable<?> entity, String trackingId) {
        Args.notNull((String)"entity", entity);
        Args.notNull((String)"trackingId", (Object)trackingId);
        Object id = entity.getId();
        if (id != null) {
            HashCodeAssignment ida = (HashCodeAssignment)HASHCODE_ASSIGNMENT_BY_ID.get(new FQId(entity.getIdRealm(), id));
            return ida == null ? id.hashCode() : ida.hashCode;
        }
        return HashCodeManager.getOrRegisterHashCodeAssignmentByTrackingId(entity, (String)trackingId).hashCode;
    }

    public static <T> String onEntityInstantiated(Identifiable<T> entity) {
        Args.notNull((String)"entity", entity);
        String trackingId = String.valueOf(LOCAL_JVM_ID) + "#" + LOCAL_ID_GENERATOR.getAndIncrement();
        GC_TRACKER.track(entity, (Object)trackingId);
        return trackingId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void onIdSet(Identifiable<T> entity, String trackingId) {
        Args.notNull((String)"entity", entity);
        Args.notNull((String)"trackingId", (Object)trackingId);
        HashCodeAssignment newHca = new HashCodeAssignment(trackingId.hashCode());
        FQId id = new FQId(entity.getIdRealm(), NullAnalysisHelper.asNonNull((Object)entity.getId()));
        HashCodeAssignment hca = HASHCODE_ASSIGNMENT_BY_ID.putIfAbsent(id, newHca);
        if (hca == null) {
            hca = newHca;
        }
        WeakIdentityHashSet<Identifiable<?>> weakIdentityHashSet = hca.identifiables;
        synchronized (weakIdentityHashSet) {
            hca.id = id;
            hca.identifiables.add(entity);
        }
        HashCodeManager.getOrRegisterHashCodeAssignmentByTrackingId(entity, (String)trackingId).id = id;
    }

    private HashCodeManager() {
    }

    private static final class FQId {
        private final Object id;
        private final Object realm;

        private FQId(Object realm, Object id) {
            this.realm = realm;
            this.id = id;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FQId other = (FQId)obj;
            return this.realm.equals(other.realm) && this.id.equals(other.id);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.id.hashCode();
            result = 31 * result + this.realm.hashCode();
            return result;
        }
    }

    private static final class HashCodeAssignment {
        final int hashCode;
        @Nullable FQId id;
        final WeakIdentityHashSet<Identifiable<?>> identifiables = WeakIdentityHashSet.create();

        protected HashCodeAssignment(int hashCode) {
            this.hashCode = hashCode;
        }
    }
}

