/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Args;
import org.eclipse.jdt.annotation.Nullable;

public class JdbcResourcesCloser {
    private static final Logger LOG = Logger.create();
    private final LinkedList<Object> resources = new LinkedList();

    private static boolean close(@Nullable Object resource) {
        block6: {
            if (resource == null) {
                return false;
            }
            try {
                if (resource instanceof Connection) {
                    ((Connection)resource).close();
                    break block6;
                }
                if (resource instanceof Statement) {
                    ((Statement)resource).close();
                    break block6;
                }
                if (resource instanceof ResultSet) {
                    ((ResultSet)resource).close();
                    break block6;
                }
                return false;
            }
            catch (SQLException ex) {
                LOG.warn((Throwable)ex, "Closing JDBC Resource %s failed.", new Object[]{resource});
                return false;
            }
        }
        return true;
    }

    public void closeAll() {
        for (Object e : this.resources) {
            JdbcResourcesCloser.close(e);
        }
        this.resources.clear();
    }

    public Object closeLast() {
        Object resource = this.resources.removeFirst();
        JdbcResourcesCloser.close(resource);
        return resource;
    }

    public CallableStatement register(CallableStatement stmt) {
        Args.notNull((String)"stmt", (Object)stmt);
        this.resources.addFirst(stmt);
        return stmt;
    }

    public Connection register(Connection con) {
        Args.notNull((String)"con", (Object)con);
        this.resources.addFirst(con);
        return con;
    }

    public PreparedStatement register(PreparedStatement stmt) {
        Args.notNull((String)"stmt", (Object)stmt);
        this.resources.addFirst(stmt);
        return stmt;
    }

    public ResultSet register(ResultSet rs) {
        Args.notNull((String)"rs", (Object)rs);
        this.resources.addFirst(rs);
        return rs;
    }

    public Statement register(Statement stmt) {
        Args.notNull((String)"stmt", (Object)stmt);
        this.resources.addFirst(stmt);
        return stmt;
    }
}

