/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence.jpa;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Date;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import javax.persistence.PostPersist;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.date.ImmutableDate;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.reflection.Fields;
import net.sf.jstuff.core.types.Identifiable;
import net.sf.jstuff.integration.persistence.HashCodeManager;
import org.eclipse.jdt.annotation.Nullable;

@MappedSuperclass
public abstract class AbstractJPAEntity<KeyType extends Serializable>
implements Serializable,
Identifiable<KeyType> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.create();
    @Transient
    private final String _hashCodeTrackingId;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="_createdOn", updatable=false, nullable=false)
    private Date _firstPersistedOn = new Date();
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="_modifiedOn", nullable=false)
    private @Nullable Date _lastPersistedOn;
    @Basic(optional=false)
    @Column(nullable=false)
    private boolean _isMarkedAsDeleted = false;
    @Version
    @Column(nullable=false)
    private int _version = 0;

    protected AbstractJPAEntity() {
        this._hashCodeTrackingId = HashCodeManager.onEntityInstantiated(this);
    }

    public final @Nullable ImmutableDate _getFirstPersistedOn() {
        if (this._isNew()) {
            return null;
        }
        return ImmutableDate.of((Date)this._firstPersistedOn);
    }

    public final @Nullable ImmutableDate _getLastPersistedOn() {
        return this._lastPersistedOn != null ? ImmutableDate.of((Date)this._lastPersistedOn) : null;
    }

    public final int _getVersion() {
        return this._version;
    }

    public final boolean _isMarkedAsDeleted() {
        return this._isMarkedAsDeleted;
    }

    public final boolean _isNew() {
        return this.getId() != null;
    }

    public void _setMarkedAsDeleted(boolean isMarkedAsDeleted) {
        this._isMarkedAsDeleted = isMarkedAsDeleted;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractJPAEntity other = (AbstractJPAEntity)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public Object getIdRealm() {
        return this.getClass();
    }

    public int hashCode() {
        return HashCodeManager.hashCodeFor(this, this._hashCodeTrackingId);
    }

    @PostPersist
    private void onAfterIdSet() {
        HashCodeManager.onIdSet(this, this._hashCodeTrackingId);
    }

    @PrePersist
    private void onPrePersist() {
        this._lastPersistedOn = new Date();
    }

    @PreUpdate
    private void onPreUpdate() {
        this._lastPersistedOn = new Date();
    }

    public CharSequence toDebugString() {
        StringBuilder sb = new StringBuilder(64);
        Class<?> currClazz = this.getClass();
        StringBuilder intend = new StringBuilder("");
        try {
            while (currClazz != Object.class && currClazz != null) {
                sb.append((CharSequence)intend).append(currClazz).append(" *** START ***").append(Strings.NEW_LINE);
                intend.append("  ");
                Field[] fieldArray = currClazz.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (!Fields.isStatic((Member)field) && !field.getName().startsWith("class$")) {
                        Object fieldValue = Fields.read((Object)this, (Field)field);
                        if (fieldValue == null || !field.getType().isAssignableFrom(AbstractJPAEntity.class)) {
                            sb.append((CharSequence)intend).append("[").append(field.getName()).append("] ").append(fieldValue).append(" | ").append(field.getType().getName()).append(Strings.NEW_LINE);
                        } else {
                            AbstractJPAEntity referencedEntity = (AbstractJPAEntity)fieldValue;
                            sb.append((CharSequence)intend).append("[").append(field.getName()).append("] id=").append(referencedEntity.getId()).append(" | ").append(referencedEntity.getClass().getName()).append(Strings.NEW_LINE);
                        }
                    }
                    ++n2;
                }
                sb.append(Strings.NEW_LINE);
                currClazz = currClazz.getSuperclass();
            }
            return sb.append(this.getClass()).append(" *** END ***").append(Strings.NEW_LINE);
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex, "toDebugString() failed on %s", new Object[]{this});
            return this.toString();
        }
    }

    public final String toString() {
        return String.valueOf(this.getClass().getName()) + "[id=" + this.getId() + ", version=, " + this._getVersion() + "hashCode=" + this.hashCode() + "]";
    }
}

