/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.persistence.jpa;

import java.util.HashMap;
import java.util.Map;
import net.sf.jstuff.core.comparator.SortBy;
import net.sf.jstuff.core.fluent.Fluent;
import org.eclipse.jdt.annotation.Nullable;

public class JpqlOrderByBuilder {
    private final SortBy<String>[] defaultSortBy;
    private final Map<String, String> mappings = new HashMap<String, String>(4);

    @SafeVarargs
    public JpqlOrderByBuilder(SortBy<String> ... defaultSortBy) {
        this.defaultSortBy = defaultSortBy;
    }

    @Fluent
    public JpqlOrderByBuilder addMapping(String sortField, String jpqlExpression) {
        this.mappings.put(sortField, jpqlExpression);
        return this;
    }

    public String buildOrderBy(SortBy<String>[] sortBy) throws IllegalArgumentException {
        StringBuilder orderBy = new StringBuilder();
        SortBy<String>[] sortByArray = this.getActiveSortBy(sortBy);
        int n = sortByArray.length;
        int n2 = 0;
        while (n2 < n) {
            SortBy<String> sb = sortByArray[n2];
            String jpqlExpression = this.mappings.get(sb.getKey());
            if (jpqlExpression == null) {
                throw new IllegalArgumentException("Invalid sorting field [" + (String)sb.getKey() + "]");
            }
            orderBy.append(' ');
            orderBy.append(jpqlExpression);
            orderBy.append(' ');
            orderBy.append(sb.getDirection());
            orderBy.append(',');
            ++n2;
        }
        orderBy.setLength(orderBy.length() - 1);
        return orderBy.toString();
    }

    public SortBy<String>[] getActiveSortBy(SortBy<String> @Nullable [] sortBy) {
        if (sortBy == null || sortBy.length == 0) {
            return this.defaultSortBy;
        }
        return sortBy;
    }
}

