/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.serviceregistry.impl;

import java.util.Objects;
import net.sf.jstuff.core.comparator.StringComparator;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.integration.serviceregistry.ServiceEndpoint;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultServiceEndpoint
implements ServiceEndpoint,
Comparable<DefaultServiceEndpoint> {
    protected final String serviceEndpointId;
    protected final Class<?> serviceInterface;

    public DefaultServiceEndpoint(String serviceEndpointId, Class<?> serviceInterface) {
        Args.notNull((String)"serviceEndpointId", (Object)serviceEndpointId);
        Args.notNull((String)"serviceInterface", serviceInterface);
        this.serviceEndpointId = serviceEndpointId;
        this.serviceInterface = serviceInterface;
    }

    @Override
    public int compareTo(@Nullable DefaultServiceEndpoint other) {
        if (other == null) {
            return 1;
        }
        int res = StringComparator.INSTANCE.compare(this.serviceEndpointId, other.serviceEndpointId);
        if (res != 0) {
            return res;
        }
        return StringComparator.INSTANCE.compare(this.serviceInterface.getName(), other.serviceInterface.getName());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultServiceEndpoint other = (DefaultServiceEndpoint)obj;
        if (!Objects.equals(this.serviceEndpointId, other.serviceEndpointId)) {
            return false;
        }
        return this.serviceInterface == other.serviceInterface;
    }

    @Override
    public String getServiceEndpointId() {
        return this.serviceEndpointId;
    }

    @Override
    public Class<?> getServiceInterface() {
        return this.serviceInterface;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.serviceEndpointId.hashCode();
        result = 31 * result + this.serviceInterface.getName().hashCode();
        return result;
    }

    public String toString() {
        return String.valueOf(ServiceEndpoint.class.getName()) + "[serviceEndpointId=" + this.serviceEndpointId + ", serviceInterface=" + this.serviceInterface + "]";
    }
}

