/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.serviceregistry.impl;

import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.jstuff.core.collection.WeakHashSet;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.serviceregistry.ServiceListener;
import net.sf.jstuff.integration.serviceregistry.ServiceProxy;
import net.sf.jstuff.integration.serviceregistry.impl.DefaultServiceRegistry;
import net.sf.jstuff.integration.serviceregistry.impl.ServiceProxyInternal;
import org.eclipse.jdt.annotation.Nullable;

public class DefaultServiceProxyAdvice<SERVICE_INTERFACE>
implements ServiceProxyInternal<SERVICE_INTERFACE> {
    private static final Logger LOG = Logger.create();
    protected final Class<SERVICE_INTERFACE> serviceInterface;
    protected final String serviceEndpointId;
    private final DefaultServiceRegistry.ServiceEndpointState serviceEndpointState;
    private final Set<ServiceListener<SERVICE_INTERFACE>> listeners = new WeakHashSet();
    private final Lock listeners_READ;
    private final Lock listeners_WRITE;
    private ServiceProxyInternal<SERVICE_INTERFACE> proxy = (ServiceProxyInternal)NullAnalysisHelper.lazyNonNull();

    public DefaultServiceProxyAdvice(DefaultServiceRegistry.ServiceEndpointState serviceEndpointState, Class<SERVICE_INTERFACE> serviceInterface) {
        Args.notNull((String)"serviceEndpointState", (Object)serviceEndpointState);
        Args.notNull((String)"serviceInterface", serviceInterface);
        this.serviceEndpointState = serviceEndpointState;
        this.serviceInterface = serviceInterface;
        this.serviceEndpointId = serviceEndpointState.getServiceEndpointId();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.listeners_READ = lock.readLock();
        this.listeners_WRITE = lock.writeLock();
    }

    @Override
    public boolean addServiceListener(ServiceListener<SERVICE_INTERFACE> listener) {
        Args.notNull((String)"listener", listener);
        this.listeners_WRITE.lock();
        try {
            boolean rc = this.listeners.add(listener);
            this.serviceEndpointState.onListenerAdded(this.proxy);
            boolean bl = rc;
            return bl;
        }
        finally {
            this.listeners_WRITE.unlock();
        }
    }

    @Override
    public SERVICE_INTERFACE get() {
        return (SERVICE_INTERFACE)this.proxy;
    }

    @Override
    public int getListenerCount() {
        this.listeners_READ.lock();
        try {
            int n = this.listeners.size();
            return n;
        }
        finally {
            this.listeners_READ.unlock();
        }
    }

    @Override
    public String getServiceEndpointId() {
        return this.serviceEndpointId;
    }

    @Override
    public @Nullable Class<?> getServiceImplementationClass() {
        SERVICE_INTERFACE service = this.serviceEndpointState.getActiveServiceIfCompatible(this.serviceInterface);
        return service == null ? null : service.getClass();
    }

    @Override
    public Class<SERVICE_INTERFACE> getServiceInterface() {
        return this.serviceInterface;
    }

    @Override
    public boolean isServiceAvailable() {
        return this.serviceEndpointState.getActiveServiceIfCompatible(this.serviceInterface) != null;
    }

    @Override
    public void onServiceAvailable() {
        if (this.serviceEndpointState.getActiveServiceIfCompatible(this.serviceInterface) != null) {
            ServiceListener[] listeners;
            this.listeners_READ.lock();
            try {
                if (this.listeners.isEmpty()) {
                    return;
                }
                listeners = this.listeners.toArray(new ServiceListener[this.listeners.size()]);
            }
            finally {
                this.listeners_READ.unlock();
            }
            ServiceListener[] serviceListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceListener listener = serviceListenerArray[n2];
                try {
                    listener.onServiceAvailable(this.proxy);
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex, "Failed to notify listener %s", new Object[]{listener});
                }
                ++n2;
            }
        }
    }

    @Override
    public void onServiceUnavailable() {
        if (this.serviceEndpointState.getActiveServiceIfCompatible(this.serviceInterface) == null) {
            ServiceListener[] listeners;
            this.listeners_READ.lock();
            try {
                if (this.listeners.isEmpty()) {
                    return;
                }
                listeners = this.listeners.toArray(new ServiceListener[this.listeners.size()]);
            }
            finally {
                this.listeners_READ.unlock();
            }
            ServiceListener[] serviceListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceListener listener = serviceListenerArray[n2];
                try {
                    listener.onServiceUnavailable(this.proxy);
                }
                catch (Exception ex) {
                    LOG.error((Throwable)ex, "Failed to notify listener %s", new Object[]{listener});
                }
                ++n2;
            }
        }
    }

    @Override
    public boolean removeServiceListener(ServiceListener<SERVICE_INTERFACE> listener) {
        Args.notNull((String)"listener", listener);
        this.listeners_WRITE.lock();
        try {
            boolean bl = this.listeners.remove(listener);
            return bl;
        }
        finally {
            this.listeners_WRITE.unlock();
        }
    }

    public void setProxy(ServiceProxyInternal<SERVICE_INTERFACE> proxy) {
        this.proxy = proxy;
    }

    public String toString() {
        return String.valueOf(ServiceProxy.class.getSimpleName()) + "[serviceEndpointId=" + this.serviceEndpointId + ", serviceInterface=" + this.serviceInterface + ", service=" + this.serviceEndpointState.getActiveServiceIfCompatible(this.serviceInterface) + "]";
    }
}

