/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.serviceregistry.support;

import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.Assert;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.serviceregistry.ServiceRegistry;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

public class ServiceAsSpringBean<@NonNull T>
implements FactoryBean<T>,
InitializingBean {
    private ServiceRegistry serviceRegistry = (ServiceRegistry)NullAnalysisHelper.lazyNonNull();
    private @Nullable String serviceEndpointId;
    private Class<T> serviceInterface = (Class)NullAnalysisHelper.lazyNonNull();
    private T service = NullAnalysisHelper.lazyNonNull();

    public synchronized void afterPropertiesSet() throws Exception {
        Assert.isNull(this.service, (String)"Already initialized!");
        Assert.notNull((Object)this.serviceRegistry, (String)"[serviceRegistry] must not be null!");
        Assert.notNull(this.serviceInterface, (String)"[serviceInterface] must not be null!");
        this.service = this.serviceRegistry.getService(this.serviceEndpointId != null ? this.serviceEndpointId : this.serviceInterface.getName(), this.serviceInterface).get();
    }

    public T getObject() throws Exception {
        return this.service;
    }

    public @Nullable Class<T> getObjectType() {
        return this.serviceInterface;
    }

    public boolean isSingleton() {
        return true;
    }

    public synchronized void setServiceEndpointId(String serviceEndpointId) {
        Args.notNull((String)"serviceEndpointId", (Object)serviceEndpointId);
        Assert.isNull(this.service, (String)"Already initialized!");
        this.serviceEndpointId = serviceEndpointId;
    }

    public synchronized void setServiceInterface(Class<T> serviceInterface) {
        Args.notNull((String)"serviceInterface", serviceInterface);
        Assert.isNull(this.service, (String)"Already initialized!");
        Assert.isTrue((boolean)serviceInterface.isInterface(), (String)("[serviceInterface] must be an interface but is " + serviceInterface));
        this.serviceInterface = serviceInterface;
    }

    public synchronized void setServiceRegistry(ServiceRegistry serviceRegistry) {
        Args.notNull((String)"serviceRegistry", (Object)serviceRegistry);
        Assert.isNull(this.service, (String)"Already initialized!");
        this.serviceRegistry = serviceRegistry;
    }
}

