/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.integration.servlet.ClassPathResourcesFilter;
import net.sf.jstuff.integration.servlet.ServletContextWrapper;
import org.eclipse.jdt.annotation.Nullable;

public class ClassPathResourcesServletContext
extends ServletContextWrapper {
    private static final Logger LOG = Logger.create();

    public ClassPathResourcesServletContext(ServletContext delegate) {
        super(delegate);
    }

    @Override
    public @Nullable ServletContext getContext(String uripath) {
        ServletContext ctx = this.delegate.getContext(uripath);
        if (ctx instanceof ClassPathResourcesServletContext) {
            return ctx;
        }
        if (ctx == this.delegate) {
            return this;
        }
        if (ctx == null) {
            return null;
        }
        return new ClassPathResourcesServletContext(ctx);
    }

    @Override
    public @Nullable URL getResource(String path) throws MalformedURLException {
        URL resource = this.delegate.getResource(path);
        if (resource == null) {
            resource = ClassPathResourcesFilter.findResourceInClassPath(path);
        }
        return resource;
    }

    @Override
    public @Nullable InputStream getResourceAsStream(String path) {
        URL resource;
        InputStream stream = this.delegate.getResourceAsStream(path);
        if (stream == null && (resource = ClassPathResourcesFilter.findResourceInClassPath(path)) != null) {
            try {
                stream = resource.openStream();
            }
            catch (IOException ex) {
                LOG.error((Throwable)ex, "Failed to open stream of resource [%s]", new Object[]{path});
            }
        }
        return stream;
    }
}

