/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import net.sf.jstuff.core.collection.ArrayUtils;
import net.sf.jstuff.core.io.IOUtils;
import net.sf.jstuff.core.io.stream.FastByteArrayOutputStream;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.Assert;
import net.sf.jstuff.integration.servlet.StatusCapturingHttpServletResponseWrapper;
import org.eclipse.jdt.annotation.Nullable;

public class ContentCapturingHttpServletResponseWrapper
extends StatusCapturingHttpServletResponseWrapper {
    private @Nullable ServletOutputStream exposedOutputStream;
    private @Nullable PrintWriter exposedPrintWriter;
    private final FastByteArrayOutputStream outputStream = new FastByteArrayOutputStream();

    public ContentCapturingHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public void clear() {
        this.outputStream.reset();
    }

    public byte[] toByteArray() {
        if (this.exposedPrintWriter != null) {
            this.exposedPrintWriter.flush();
        }
        return this.outputStream.toByteArray();
    }

    public void copyTo(OutputStream target) throws IOException {
        Args.notNull((String)"target", (Object)target);
        IOUtils.copy((InputStream)this.outputStream.toInputStream(), (OutputStream)target);
    }

    public String toString() {
        try {
            String encoding = this.getCharacterEncoding();
            return this.outputStream.toString(encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public ServletOutputStream getOutputStream() {
        Assert.isNull((Object)this.exposedPrintWriter, (String)"getWriter() was called already!");
        ServletOutputStream exposedOutputStream = this.exposedOutputStream;
        if (exposedOutputStream == null) {
            exposedOutputStream = this.exposedOutputStream = new ServletOutputStream(){

                public void write(byte[] b) throws IOException {
                    ContentCapturingHttpServletResponseWrapper.this.outputStream.write(b);
                }

                public void write(byte[] b, int off, int len) throws IOException {
                    ContentCapturingHttpServletResponseWrapper.this.outputStream.write(b, off, len);
                }

                public void write(int b) throws IOException {
                    ContentCapturingHttpServletResponseWrapper.this.outputStream.write(b);
                }

                public boolean isReady() {
                    throw new UnsupportedOperationException();
                }

                public void setWriteListener(WriteListener writeListener) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return exposedOutputStream;
    }

    public PrintWriter getWriter() {
        Assert.isNull((Object)this.exposedOutputStream, (String)"getOutpuStream() was called already!");
        PrintWriter exposedPrintWriter = this.exposedPrintWriter;
        if (exposedPrintWriter == null) {
            exposedPrintWriter = this.exposedPrintWriter = new PrintWriter(new Writer(){

                @Override
                public void write(String str) throws IOException {
                    ContentCapturingHttpServletResponseWrapper.this.outputStream.write(str.getBytes(ContentCapturingHttpServletResponseWrapper.this.getCharacterEncoding()));
                }

                @Override
                public void write(char[] cbuf, int off, int len) throws IOException {
                    Charset charset = Charset.forName(ContentCapturingHttpServletResponseWrapper.this.getCharacterEncoding());
                    ContentCapturingHttpServletResponseWrapper.this.outputStream.write(ArrayUtils.toByteArray((char[])cbuf, (int)off, (int)len, (Charset)charset));
                }

                @Override
                public void flush() throws IOException {
                }

                @Override
                public void close() throws IOException {
                }
            }){

                @Override
                public void write(String str) {
                    try {
                        ContentCapturingHttpServletResponseWrapper.this.outputStream.write(str.getBytes(ContentCapturingHttpServletResponseWrapper.this.getCharacterEncoding()));
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }
        return exposedPrintWriter;
    }
}

