/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.sf.jstuff.core.collection.CollectionUtils;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.reflection.Types;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DummyPrincipalInjectingFilter
implements Filter {
    private static final Logger LOG = Logger.create();
    public static final String USER_NAME_SYSTEM_PROPERTY = "net.sf.jstuff.integration.servlet.dummyUsername";
    public static final String USER_ROLES_SYSTEM_PROPERTY = "net.sf.jstuff.integration.servlet.dummyUserRoles";
    public static final String USER_ROLES_SEPARATOR = ",";
    public static @Nullable String DEFAULT_USER_NAME;
    public static @NonNull String @Nullable [] DEFAULT_USER_ROLES;
    private final ThreadLocal<HttpServletRequestWrapper> requestWrapper = new ThreadLocal<HttpServletRequestWrapper>(){
        final HttpServletRequest init = (HttpServletRequest)Types.createMixin(HttpServletRequest.class, (Object[])new Object[]{new Object()});

        @Override
        protected synchronized HttpServletRequestWrapper initialValue() {
            return new HttpServletRequestWrapper(this.init){

                public @Nullable String getRemoteUser() {
                    return (this).DummyPrincipalInjectingFilter.this.user.getName();
                }

                public @Nullable Principal getUserPrincipal() {
                    return (this).DummyPrincipalInjectingFilter.this.user;
                }

                public boolean isUserInRole(String roleName) {
                    return (this).DummyPrincipalInjectingFilter.this.userRoles.contains(roleName);
                }
            };
        }
    };
    private final Principal user = new Principal(){

        @Override
        public String getName() {
            return DummyPrincipalInjectingFilter.this.username != null ? DummyPrincipalInjectingFilter.this.username : "unauthenticated";
        }

        @Override
        public String toString() {
            return String.valueOf(Principal.class.getName()) + "[name=" + DummyPrincipalInjectingFilter.this.username + ", roles=" + DummyPrincipalInjectingFilter.this.userRoles + "]";
        }
    };
    private @Nullable String username;
    private final Set<String> userRoles = new HashSet<String>();

    public DummyPrincipalInjectingFilter() {
        LOG.infoNew((Object)this);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.username != null && request instanceof HttpServletRequest) {
            LOG.debug("Injecting dummy user [%s]...", (Object)this.username);
            HttpServletRequestWrapper wrapper = this.requestWrapper.get();
            wrapper.setRequest(request);
            chain.doFilter((ServletRequest)wrapper, response);
        } else {
            chain.doFilter(request, response);
        }
    }

    public @Nullable String getUsername() {
        return this.username;
    }

    public Set<String> getUserRoles() {
        return this.userRoles;
    }

    public void init(FilterConfig config) throws ServletException {
        String userRoles;
        String userRoles2;
        String uname = System.getProperty(USER_NAME_SYSTEM_PROPERTY);
        if (uname != null) {
            this.setUsername(uname);
        }
        if ((userRoles2 = System.getProperty(USER_ROLES_SYSTEM_PROPERTY)) != null) {
            this.setUserRoles(userRoles2.split(USER_ROLES_SEPARATOR));
        }
        if (this.getUsername() == null && (uname = config.getInitParameter("username")) != null) {
            this.setUsername(uname);
        }
        if (this.userRoles.isEmpty() && (userRoles = config.getInitParameter("user-roles")) != null) {
            this.setUserRoles(userRoles.split(USER_ROLES_SEPARATOR));
        }
        if (this.getUsername() == null) {
            this.setUsername(DEFAULT_USER_NAME);
        }
        if (this.userRoles.isEmpty()) {
            this.setUserRoles(DEFAULT_USER_ROLES);
        }
    }

    public void setUsername(@Nullable String name) {
        this.username = name;
    }

    public void setUserRoles(@Nullable Collection<String> userRoles) {
        this.userRoles.clear();
        if (userRoles != null) {
            this.userRoles.addAll(userRoles);
        }
    }

    public void setUserRoles(String ... userRoles) {
        this.userRoles.clear();
        if (userRoles != null) {
            CollectionUtils.addAll(this.userRoles, (Object[])userRoles);
        }
    }
}

