/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.core.collection.CollectionUtils;
import net.sf.jstuff.core.collection.Loops;
import net.sf.jstuff.core.io.CharEncoding;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.security.Base64;
import net.sf.jstuff.core.security.x509.X509Utils;

public class ForwardedClientCertificateFilter
implements Filter {
    private static final Logger LOG = Logger.create();
    public static final String SERVLET_ATTRIBUTE = "javax.servlet.request.X509Certificate";
    public static final String REQUEST_HEADER = "X-Forwarded-Client-Cert";

    public ForwardedClientCertificateFilter() {
        LOG.infoNew((Object)this);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block7: {
            if (request instanceof HttpServletRequest) {
                try {
                    ArrayList certsEncoded = new ArrayList();
                    Loops.forEach((Enumeration)((HttpServletRequest)request).getHeaders(REQUEST_HEADER), header -> {
                        if (Strings.isBlank((CharSequence)header)) {
                            return;
                        }
                        if (Strings.contains((CharSequence)(header = header.trim()), (int)44)) {
                            CollectionUtils.addAll((Collection)certsEncoded, (Object[])Strings.split((String)header, (char)','));
                        } else {
                            certsEncoded.add(header);
                        }
                    });
                    if (certsEncoded.isEmpty()) break block7;
                    ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(certsEncoded.size());
                    for (String certEncoded : certsEncoded) {
                        byte[] certDecoded = null;
                        try {
                            certDecoded = Base64.decode((String)certEncoded);
                        }
                        catch (Exception ex) {
                            LOG.debug((Throwable)ex);
                            certDecoded = URLDecoder.decode(certEncoded, CharEncoding.UTF_8.charset).getBytes();
                        }
                        certs.add(X509Utils.getCertificate((byte[])certDecoded));
                    }
                    if (!certs.isEmpty()) {
                        request.setAttribute(SERVLET_ATTRIBUTE, (Object)certs.toArray(new X509Certificate[certs.size()]));
                    }
                }
                catch (Exception ex) {
                    LOG.error("Parsing certificates of HTTP header 'X-Forwarded-Client-Cert' failed.", (Object)ex);
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }
}

