/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.sf.jstuff.core.collection.Loops;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.NullAnalysisHelper;

public class HttpServletResponseHeaderSettingFilter
implements Filter {
    private static final Logger LOG = Logger.create();
    private final Map<String, String> parameter = new LinkedHashMap<String, String>();

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("For request %s setting HTTP response headers: %s", (Object)request, this.parameter);
        HttpServletResponse res = (HttpServletResponse)response;
        for (Map.Entry<String, String> entry : this.parameter.entrySet()) {
            res.setHeader(entry.getKey(), entry.getValue());
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        Loops.forEach((Enumeration)filterConfig.getInitParameterNames(), param -> this.parameter.put((String)param, (String)NullAnalysisHelper.asNonNullUnsafe((Object)filterConfig.getInitParameter(param))));
    }
}

