/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.Nullable;

public class RequestResponseHoldingFilter
implements Filter {
    private static final ThreadLocal<ServletRequest> REQ = new ThreadLocal();
    private static final ThreadLocal<ServletResponse> RESP = new ThreadLocal();

    public static @Nullable HttpServletRequest getHttpServletRequest() {
        ServletRequest req = REQ.get();
        if (req instanceof HttpServletRequest) {
            return (HttpServletRequest)req;
        }
        return null;
    }

    public static @Nullable HttpServletResponse getHttpServletResponse() {
        ServletResponse resp = RESP.get();
        if (resp instanceof HttpServletResponse) {
            return (HttpServletResponse)resp;
        }
        return null;
    }

    public static ServletRequest getServletRequest() {
        return REQ.get();
    }

    public static ServletResponse getServletResponse() {
        return RESP.get();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        REQ.set(request);
        try {
            RESP.set(response);
            try {
                chain.doFilter(request, response);
            }
            finally {
                RESP.remove();
            }
        }
        finally {
            REQ.remove();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

