/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.servlet.session;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.jstuff.core.collection.Enumerations;
import net.sf.jstuff.core.collection.Loops;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.servlet.session.SessionMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HttpSessionMap
implements SessionMap {
    private final HttpServletRequest request;

    public HttpSessionMap(HttpServletRequest request) {
        Args.notNull((String)"request", (Object)request);
        this.request = request;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return false;
        }
        return Enumerations.contains((Enumeration)sess.getAttributeNames(), (Object)key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return false;
        }
        for (String key : Enumerations.toIterable((Enumeration)sess.getAttributeNames())) {
            if (!Objects.equals(sess.getAttribute(key), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return Collections.emptySet();
        }
        HashMap result = new HashMap();
        Loops.forEach((Enumeration)sess.getAttributeNames(), key -> {
            Object object = result.put(key, NullAnalysisHelper.asNonNullUnsafe((Object)sess.getAttribute(key)));
        });
        return result.entrySet();
    }

    @Override
    public boolean exists() {
        return this.request.getSession(false) != null;
    }

    @Override
    public @Nullable Object get(@Nullable Object key) {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return null;
        }
        return sess.getAttribute(key == null ? null : key.toString());
    }

    @Override
    public Object get(String key, Object defaultValueIfNull) {
        Object val = this.get(key);
        if (val == null) {
            return defaultValueIfNull;
        }
        return val;
    }

    @Override
    public Object getId() {
        HttpSession sess = this.request.getSession();
        return sess.getId();
    }

    @Override
    public void invalidate() {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return;
        }
        sess.invalidate();
    }

    @Override
    public boolean isEmpty() {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return true;
        }
        return !sess.getAttributeNames().hasMoreElements();
    }

    @Override
    public Set<String> keySet() {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        Loops.forEach((Enumeration)sess.getAttributeNames(), result::add);
        return result;
    }

    @Override
    public @Nullable Object put(@Nullable String key, Object value) {
        HttpSession sess = this.request.getSession();
        Object oldValue = sess.getAttribute(key);
        sess.setAttribute(key, value);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends String, @NonNull ?> map) {
        HttpSession sess = this.request.getSession();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            sess.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public @Nullable Object remove(@Nullable Object key) {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return null;
        }
        Object oldValue = sess.getAttribute(key == null ? null : key.toString());
        sess.removeAttribute(key == null ? null : key.toString());
        return oldValue;
    }

    @Override
    public int size() {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return 0;
        }
        return Enumerations.size((Enumeration)sess.getAttributeNames());
    }

    @Override
    public Collection<Object> values() {
        HttpSession sess = this.request.getSession(false);
        if (sess == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Loops.forEach((Enumeration)sess.getAttributeNames(), key -> {
            boolean bl = result.add(NullAnalysisHelper.asNonNullUnsafe((Object)sess.getAttribute(key)));
        });
        return result;
    }
}

