/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.spring;

import java.util.List;
import java.util.Map;
import javax.annotation.PreDestroy;
import net.sf.jstuff.core.collection.ObjectCache;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Assert;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.stereotype.Component;

@Component
public final class SpringBeanInjector {
    private static final Logger LOG = Logger.create();
    private static @Nullable SpringBeanInjector instance;
    private final ObjectCache<String, Object> registeredSingletons = new ObjectCache(true);
    @Autowired
    private DefaultListableBeanFactory beanFactory;
    @Autowired
    private List<DestructionAwareBeanPostProcessor> destructors;

    public static SpringBeanInjector get() {
        return (SpringBeanInjector)Assert.notNull((Object)instance, (String)("No SpringBeanInjector instance created yet. Add <bean class=\"" + SpringBeanInjector.class.getName() + "\" /> to your spring configuration!"));
    }

    private SpringBeanInjector() {
        Assert.isNull((Object)instance, (String)("A instance of " + this.getClass().getName() + " already exists."));
        LOG.infoNew((Object)this);
        instance = this;
    }

    private void destroy(Object unmanagedBean) throws Exception {
        LOG.entry(unmanagedBean);
        for (DestructionAwareBeanPostProcessor destructor : this.destructors) {
            destructor.postProcessBeforeDestruction(unmanagedBean, "bean");
        }
        if (unmanagedBean instanceof DisposableBean) {
            ((DisposableBean)unmanagedBean).destroy();
        }
        LOG.exit();
    }

    public void inject(Object unmanagedBean) {
        LOG.entry(unmanagedBean);
        this.beanFactory.autowireBean(unmanagedBean);
        LOG.exit();
    }

    @PreDestroy
    private void onDestroy() {
        for (Map.Entry s : this.registeredSingletons.getAll().entrySet()) {
            try {
                this.beanFactory.destroySingleton((String)s.getKey());
                this.destroy(s.getValue());
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
            }
        }
        instance = null;
    }

    public void registerSingleton(String beanName, Object uninitializedBean) {
        LOG.entry(uninitializedBean);
        this.beanFactory.autowireBean(uninitializedBean);
        this.beanFactory.initializeBean(uninitializedBean, beanName);
        this.beanFactory.registerSingleton(beanName, uninitializedBean);
        this.registeredSingletons.put((Object)beanName, uninitializedBean);
        LOG.exit();
    }
}

