/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.spring;

import java.util.Map;
import javax.annotation.PreDestroy;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.Assert;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class SpringBeanLocator {
    private static final Logger LOG = Logger.create();
    private static @Nullable SpringBeanLocator instance;
    @Autowired
    private ListableBeanFactory factory;

    public static SpringBeanLocator get() {
        return (SpringBeanLocator)Assert.notNull((Object)instance, (String)"Spring context not initialized yet.");
    }

    private SpringBeanLocator() {
        Assert.isNull((Object)instance, (String)("A instance of " + this.getClass().getName() + " already exists."));
        LOG.infoNew((Object)this);
        instance = this;
    }

    public <T> T byClass(Class<T> beanType) {
        Args.notNull((String)"beanType", beanType);
        Map beans = this.factory.getBeansOfType(beanType, true, true);
        if (beans.isEmpty()) {
            throw new IllegalArgumentException("No Spring managed bean for type '" + beanType.getName() + "' was found.");
        }
        if (beans.size() > 1) {
            throw new IllegalStateException("More than one Spring managed bean for type '" + beanType.getName() + "' was found.");
        }
        return (T)beans.values().iterator().next();
    }

    public <T> T byName(String beanName) {
        Assert.notNull((Object)beanName, (String)"[beanName] must not be null.");
        try {
            return (T)this.factory.getBean(beanName);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            throw new IllegalArgumentException("No Spring managed bean for name '" + beanName + "' was found.");
        }
    }

    public ListableBeanFactory getBeanFactory() {
        return this.factory;
    }

    @PreDestroy
    private void onDestroy() {
        instance = null;
    }
}

