/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.spring;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jstuff.core.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.web.HttpRequestHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringHttpServicesServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.create();
    private boolean showIndex = true;

    public SpringHttpServicesServlet() {
        LOG.infoNew((Object)this);
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String relativePath = request.getPathInfo();
        WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
        if (relativePath == null || "/".equals(relativePath)) {
            if (this.showIndex) {
                Map beans = springContext.getBeansOfType(HttpRequestHandler.class);
                PrintWriter pw = response.getWriter();
                pw.write("<html><body>");
                pw.write("<h3>Available services:</h3>");
                pw.write("<ul>");
                String contextRoot = request.getRequestURI();
                if (!contextRoot.endsWith("/")) {
                    contextRoot = String.valueOf(contextRoot) + "/";
                }
                for (Map.Entry entry : beans.entrySet()) {
                    if (!((String)entry.getKey()).startsWith("/")) continue;
                    String serviceID = ((String)entry.getKey()).substring(1);
                    pw.write("<li>");
                    pw.write("<a href=\"" + contextRoot + serviceID + "\">" + serviceID + "</a>");
                    pw.write("</li>");
                }
                pw.write("</ul></body></html>");
                pw.flush();
                pw.close();
            } else {
                response.sendError(403);
            }
            return;
        }
        try {
            String beanName = relativePath;
            while (beanName.contains("/")) {
                if (springContext.containsBean(beanName)) {
                    request.setAttribute("beanName", (Object)beanName);
                    ((HttpRequestHandler)springContext.getBean(beanName, HttpRequestHandler.class)).handleRequest(request, response);
                    return;
                }
                beanName = StringUtils.substringBeforeLast((String)beanName, (String)"/");
            }
        }
        catch (BeansException ex) {
            LOG.error((Throwable)ex, "Unexpected exception occured while retrieving bean [%s].", new Object[]{relativePath});
        }
        response.sendError(404);
    }

    public void setShowIndex(boolean showIndex) {
        this.showIndex = showIndex;
    }
}

