/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.spring.convert;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jstuff.core.Strings;
import net.sf.jstuff.integration.spring.convert.AbstractConverter;
import org.eclipse.jdt.annotation.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class StringToMapConverter
extends AbstractConverter {
    private static final char ENTRY_SEPARATOR = ';';
    private static final String VALUE_ASSIGNMENT = "=>";

    public StringToMapConverter() {
    }

    public StringToMapConverter(ConversionService conversionService) {
        super(conversionService);
    }

    public @Nullable Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        String sourceString = (String)source;
        if (sourceString == null || Strings.isBlank((CharSequence)sourceString)) {
            return Collections.emptyMap();
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        String[] stringArray = Strings.split((String)sourceString, (char)';');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            String[] entryArr = Strings.splitByWholeSeparator((String)entry, (String)VALUE_ASSIGNMENT);
            String key = entryArr[0].trim();
            String value = entryArr[1].trim();
            result.put(this.conversionService.convert((Object)key, sourceType, targetType.getMapKeyTypeDescriptor((Object)key)), this.conversionService.convert((Object)value, sourceType, targetType.getMapValueTypeDescriptor()));
            ++n2;
        }
        return result;
    }

    public @Nullable Set<// Could not load outer class - annotation placement on inner may be incorrect
    GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(String.class, Map.class));
    }
}

