/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.integration.userregistry.ldap;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.sf.jstuff.core.collection.Loops;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.core.validation.Args;
import net.sf.jstuff.core.validation.NullAnalysisHelper;
import net.sf.jstuff.integration.ldap.LdapTemplate;
import net.sf.jstuff.integration.ldap.LdapUtils;
import net.sf.jstuff.integration.userregistry.DefaultGroupDetails;
import net.sf.jstuff.integration.userregistry.GroupDetails;
import net.sf.jstuff.integration.userregistry.GroupDetailsService;
import org.eclipse.jdt.annotation.Nullable;

public class LdapGroupDetailsService
implements GroupDetailsService {
    private static final Logger LOG = Logger.create();
    protected String groupAttributeDisplayName = (String)NullAnalysisHelper.lazyNonNull();
    protected String groupAttributeGroupId = (String)NullAnalysisHelper.lazyNonNull();
    protected String groupAttributeMember = (String)NullAnalysisHelper.lazyNonNull();
    protected String groupSearchBase = (String)NullAnalysisHelper.lazyNonNull();
    protected String groupSearchFilter = (String)NullAnalysisHelper.lazyNonNull();
    protected boolean groupSearchSubtree = true;
    private LdapTemplate ldapTemplate = (LdapTemplate)NullAnalysisHelper.lazyNonNull();

    public LdapGroupDetailsService() {
        LOG.infoNew((Object)this);
    }

    @Override
    public @Nullable GroupDetails getGroupDetailsByGroupDN(String groupDN) {
        Args.notNull((String)"groupDN", (Object)groupDN);
        return (GroupDetails)this.ldapTemplate.execute(ctx -> {
            Attributes attrs = ctx.getAttributes(groupDN, new String[]{this.groupAttributeDisplayName, this.groupAttributeGroupId, this.groupAttributeMember});
            HashSet<String> memberDNs = new HashSet<String>();
            Attribute members = attrs.get(this.groupAttributeMember);
            if (members != null) {
                Loops.forEach(members.getAll(), dn -> {
                    boolean bl = memberDNs.add(dn.toString());
                });
            }
            return new DefaultGroupDetails(LdapUtils.getAttributeValue(attrs, this.groupAttributeGroupId, "n/a"), LdapUtils.getAttributeValue(attrs, this.groupAttributeDisplayName, "n/a"), groupDN, memberDNs);
        });
    }

    @Override
    public Set<String> getGroupIdsByUserDN(String userDN) {
        Args.notNull((String)"userDN", (Object)userDN);
        return (Set)this.ldapTemplate.execute(ctx -> {
            HashSet groupIds = new HashSet();
            LOG.trace("Performing LDAP Group Search for %s=%s", (Object)this.groupAttributeMember, (Object)userDN);
            Loops.forEach(this.searchGroup((DirContext)ctx, String.valueOf(this.groupAttributeMember) + "=" + userDN, new String[]{this.groupAttributeGroupId}), sr -> {
                boolean bl = groupIds.add(LdapUtils.getAttributeValue(sr, this.groupAttributeGroupId, "n/a"));
            });
            LOG.trace("Found %s group(s) for user %s", (Object)groupIds.size(), (Object)userDN);
            return groupIds;
        });
    }

    protected NamingEnumeration<SearchResult> searchGroup(DirContext ctx, String filter, String[] attrs) throws NamingException {
        SearchControls options = new SearchControls();
        options.setSearchScope(this.groupSearchSubtree ? 2 : 1);
        options.setReturningAttributes(attrs);
        return ctx.search(this.groupSearchBase, "(&(" + filter + ")(" + this.groupSearchFilter + "))", options);
    }

    @Inject
    public void setGroupAttributeDisplayName(String groupAttributeDisplayName) {
        Args.notNull((String)"groupAttributeDisplayName", (Object)groupAttributeDisplayName);
        this.groupAttributeDisplayName = groupAttributeDisplayName;
    }

    @Inject
    public void setGroupAttributeGroupId(String groupAttributeGroupId) {
        Args.notNull((String)"groupAttributeGroupId", (Object)groupAttributeGroupId);
        this.groupAttributeGroupId = groupAttributeGroupId;
    }

    @Inject
    public void setGroupAttributeMember(String groupAttributeMember) {
        Args.notNull((String)"groupAttributeMember", (Object)groupAttributeMember);
        this.groupAttributeMember = groupAttributeMember;
    }

    @Inject
    public void setGroupSearchBase(String groupSearchBase) {
        Args.notNull((String)"groupSearchBase", (Object)groupSearchBase);
        this.groupSearchBase = groupSearchBase;
    }

    @Inject
    public void setGroupSearchFilter(String groupSearchFilter) {
        Args.notNull((String)"groupSearchFilter", (Object)groupSearchFilter);
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setGroupSearchSubtree(boolean groupSearchSubtree) {
        this.groupSearchSubtree = groupSearchSubtree;
    }

    @Inject
    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        Args.notNull((String)"ldapTemplate", (Object)ldapTemplate);
        this.ldapTemplate = ldapTemplate;
    }
}

